/*
 * Decompiled with CFR 0.152.
 */
package org.directwebremoting.extend;

import java.io.ByteArrayInputStream;
import java.io.InputStream;

public class FormField {
    private boolean file;
    private byte[] bytes;
    private String name;
    private String mimeType;
    private String string;

    public FormField(String value) {
        this.name = null;
        this.mimeType = null;
        this.file = false;
        this.bytes = value.getBytes();
        this.string = value;
    }

    public FormField(String name, String mimeType, byte[] bytes) {
        this.name = name;
        this.mimeType = mimeType;
        this.file = true;
        this.bytes = bytes;
        this.string = null;
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public InputStream getInputStream() {
        return new ByteArrayInputStream(this.bytes);
    }

    public String getName() {
        return this.name;
    }

    public String getString() {
        if (this.string == null && this.bytes != null) {
            this.string = new String(this.bytes);
        }
        return this.string;
    }

    public boolean isFile() {
        return this.file;
    }

    public String toString() {
        if (this.file) {
            return "FormField: " + "byteCount=" + (this.bytes == null ? 0 : this.bytes.length);
        }
        return "FormField: " + this.getString();
    }

    public int hashCode() {
        int hash = 0;
        if (this.file) {
            if (this.mimeType != null) {
                hash += this.mimeType.hashCode();
            }
            if (this.name != null) {
                hash += this.name.hashCode();
            }
        }
        return hash += this.getString().hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof FormField)) {
            return false;
        }
        FormField that = (FormField)obj;
        if (this.file != that.file) {
            return false;
        }
        if (this.file) {
            if (!this.equals(this.mimeType, that.mimeType)) {
                return false;
            }
            if (!this.equals(this.name, that.name)) {
                return false;
            }
        }
        if (this.bytes.length != that.bytes.length) {
            return false;
        }
        for (int i = 0; i < this.bytes.length; ++i) {
            if (this.bytes[i] == that.bytes[i]) continue;
            return false;
        }
        return true;
    }

    private boolean equals(Object o1, Object o2) {
        if (o1 == null) {
            return o2 == null;
        }
        return o1.equals(o2);
    }
}

