/*
 * Decompiled with CFR 0.152.
 */
package org.directwebremoting.extend;

import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.directwebremoting.extend.FormField;
import org.directwebremoting.extend.InboundVariable;
import org.directwebremoting.extend.MarshallException;
import org.directwebremoting.extend.TypeHintContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class InboundContext {
    private LinkedList<TypeHintContext> typeHintStack = new LinkedList();
    private int paramCount = 0;
    private final Map<String, InboundVariable> variables = new HashMap<String, InboundVariable>();
    private Map<Conversion, Object> converted = new HashMap<Conversion, Object>();
    private static final Log log = LogFactory.getLog(InboundContext.class);

    public void dereference() throws MarshallException {
        for (InboundVariable variable : this.variables.values()) {
            variable.dereference();
        }
    }

    public void pushContext(TypeHintContext context) {
        this.typeHintStack.addFirst(context);
    }

    public void popContext() {
        this.typeHintStack.removeFirst();
    }

    public TypeHintContext getCurrentTypeHintContext() {
        return this.typeHintStack.getFirst();
    }

    public void createInboundVariable(int callNum, String key, String type, String value) {
        InboundVariable cte = new InboundVariable(this, key, type, value);
        this.checkInboundVariable(callNum, key, cte);
    }

    public void createInboundVariable(int callNum, String key, String type, FormField value) {
        InboundVariable iv = new InboundVariable(this, key, type, value);
        this.checkInboundVariable(callNum, key, iv);
    }

    private void checkInboundVariable(int callNum, String key, InboundVariable iv) {
        int i;
        String paramPrefix;
        InboundVariable old = this.variables.put(key, iv);
        if (old != null) {
            log.warn((Object)("Duplicate variable called: " + key));
        }
        if (key.startsWith(paramPrefix = "c" + callNum + "-" + "param") && (i = Integer.parseInt(key.substring(paramPrefix.length())) + 1) > this.paramCount) {
            this.paramCount = i;
        }
    }

    public InboundVariable getInboundVariable(String name) {
        return this.variables.get(name);
    }

    public void clearConverted() {
        this.converted.clear();
    }

    public void addConverted(InboundVariable iv, Class<?> type, Object bean) {
        Conversion conversion = new Conversion(iv, type);
        Object old = this.converted.put(conversion, bean);
        if (old != null) {
            log.warn((Object)("Duplicate variable conversion called: " + conversion));
        }
    }

    public Object getConverted(InboundVariable iv, Class<?> type) {
        Conversion conversion = new Conversion(iv, type);
        return this.converted.get(conversion);
    }

    public int getParameterCount() {
        return this.paramCount;
    }

    public int getParameterCount(int callNum) {
        int count = 0;
        String prefix = "c" + callNum + "-" + "param";
        for (String key : this.variables.keySet()) {
            if (!key.startsWith(prefix)) continue;
            ++count;
        }
        return count;
    }

    public InboundVariable getParameter(int callNum, int index) {
        String key = "c" + callNum + "-" + "param" + index;
        return this.variables.get(key);
    }

    public Iterator<String> getInboundVariableNames() {
        return this.variables.keySet().iterator();
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("InboundContext[");
        for (Map.Entry<String, InboundVariable> entry : this.variables.entrySet()) {
            buffer.append(entry.getKey());
            buffer.append('=');
            buffer.append(entry.getValue());
            buffer.append(',');
        }
        buffer.append("]");
        return buffer.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class Conversion {
        private final InboundVariable inboundVariable;
        private final Class<?> type;

        Conversion(InboundVariable inboundVariable, Class<?> type) {
            if (inboundVariable == null) {
                throw new NullPointerException("InboundVariable");
            }
            if (type == null) {
                throw new NullPointerException("Class type");
            }
            this.inboundVariable = inboundVariable;
            this.type = type;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof Conversion)) {
                return false;
            }
            Conversion that = (Conversion)obj;
            return this.type.equals(that.type) && this.inboundVariable.equals(that.inboundVariable);
        }

        public int hashCode() {
            return this.inboundVariable.hashCode() + this.type.hashCode();
        }

        public String toString() {
            return "Conversion[" + this.inboundVariable + "," + this.type.getName() + "]";
        }
    }
}

