/*
 * Decompiled with CFR 0.152.
 */
package org.directwebremoting.impl;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServlet;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.directwebremoting.Container;
import org.directwebremoting.HubFactory;
import org.directwebremoting.ServerContext;
import org.directwebremoting.ServerContextFactory;
import org.directwebremoting.WebContextFactory;
import org.directwebremoting.annotations.AnnotationsConfigurator;
import org.directwebremoting.dwrp.DefaultConverterManager;
import org.directwebremoting.dwrp.HtmlCallMarshaller;
import org.directwebremoting.dwrp.PlainCallMarshaller;
import org.directwebremoting.extend.AccessControl;
import org.directwebremoting.extend.AjaxFilterManager;
import org.directwebremoting.extend.Configurator;
import org.directwebremoting.extend.ContainerAbstraction;
import org.directwebremoting.extend.ContainerConfigurationException;
import org.directwebremoting.extend.ConverterManager;
import org.directwebremoting.extend.Creator;
import org.directwebremoting.extend.CreatorManager;
import org.directwebremoting.extend.DebugPageGenerator;
import org.directwebremoting.extend.DownloadManager;
import org.directwebremoting.extend.PageNormalizer;
import org.directwebremoting.extend.Remoter;
import org.directwebremoting.extend.ScriptSessionManager;
import org.directwebremoting.extend.ServerLoadMonitor;
import org.directwebremoting.impl.DefaultAccessControl;
import org.directwebremoting.impl.DefaultAjaxFilterManager;
import org.directwebremoting.impl.DefaultContainer;
import org.directwebremoting.impl.DefaultCreatorManager;
import org.directwebremoting.impl.DefaultDebugPageGenerator;
import org.directwebremoting.impl.DefaultHubBuilder;
import org.directwebremoting.impl.DefaultPageNormalizer;
import org.directwebremoting.impl.DefaultRemoter;
import org.directwebremoting.impl.DefaultScriptSessionManager;
import org.directwebremoting.impl.DefaultServerContextBuilder;
import org.directwebremoting.impl.DefaultWebContextBuilder;
import org.directwebremoting.impl.DwrXmlConfigurator;
import org.directwebremoting.impl.GrizzlyContainerAbstraction;
import org.directwebremoting.impl.InMemoryDownloadManager;
import org.directwebremoting.impl.JettyContainerAbstraction;
import org.directwebremoting.impl.ServletSpecContainerAbstraction;
import org.directwebremoting.servlet.AboutHandler;
import org.directwebremoting.servlet.AuthHandler;
import org.directwebremoting.servlet.DownloadHandler;
import org.directwebremoting.servlet.EngineHandler;
import org.directwebremoting.servlet.GiHandler;
import org.directwebremoting.servlet.HtmlCallHandler;
import org.directwebremoting.servlet.HtmlPollHandler;
import org.directwebremoting.servlet.IndexHandler;
import org.directwebremoting.servlet.InterfaceHandler;
import org.directwebremoting.servlet.MonitorHandler;
import org.directwebremoting.servlet.PlainCallHandler;
import org.directwebremoting.servlet.PlainPollHandler;
import org.directwebremoting.servlet.TestHandler;
import org.directwebremoting.servlet.UrlProcessor;
import org.directwebremoting.servlet.UtilHandler;
import org.directwebremoting.servlet.WebworkUtilHandler;
import org.directwebremoting.util.LocalUtil;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContainerUtil {
    public static final String INIT_CONFIG = "config";
    public static final String INIT_SKIP_DEFAULT = "skipDefaultConfig";
    public static final String INIT_LOGLEVEL = "logLevel";
    public static final String INIT_CUSTOM_CONFIGURATOR = "customConfigurator";
    public static final String ATTRIBUTE_CONTAINER_LIST = "org.directwebremoting.ContainerList";
    public static final String DEFAULT_SERVERCONTEXT_NAME = "__default";
    private static final Map<String, ServerContext> contextMap = new HashMap<String, ServerContext>();
    private static final Log log = LogFactory.getLog(ContainerUtil.class);

    public static Container createAndSetupDefaultContainer(ServletConfig servletConfig) throws ContainerConfigurationException {
        DefaultContainer container;
        try {
            String typeName = servletConfig.getInitParameter(Container.class.getName());
            if (typeName == null) {
                container = new DefaultContainer();
            } else {
                log.debug((Object)("Using alternate Container implementation: " + typeName));
                Class<?> type = LocalUtil.classForName(typeName);
                container = (DefaultContainer)type.newInstance();
            }
            if (container instanceof DefaultContainer) {
                DefaultContainer defaultContainer = container;
                ContainerUtil.setupDefaultContainer(defaultContainer, servletConfig);
            }
        }
        catch (Exception ex) {
            throw new ContainerConfigurationException(ex);
        }
        return container;
    }

    @Deprecated
    public static DefaultContainer createDefaultContainer(ServletConfig servletConfig) throws ContainerConfigurationException {
        try {
            String typeName = servletConfig.getInitParameter(Container.class.getName());
            if (typeName == null) {
                return new DefaultContainer();
            }
            log.debug((Object)("Using alternate Container implementation: " + typeName));
            Class<?> type = LocalUtil.classForName(typeName);
            return (DefaultContainer)type.newInstance();
        }
        catch (Exception ex) {
            throw new ContainerConfigurationException(ex);
        }
    }

    public static void setupDefaultContainer(DefaultContainer container, ServletConfig servletConfig) throws ContainerConfigurationException {
        ContainerUtil.setupDefaults(container);
        ContainerUtil.setupFromServletConfig(container, servletConfig);
        ContainerUtil.resolveContainerAbstraction(container, servletConfig);
        container.setupFinished();
    }

    public static void resolveContainerAbstraction(DefaultContainer container, ServletConfig servletConfig) throws ContainerConfigurationException {
        String abstractionImplNames = container.getParameter(ContainerAbstraction.class.getName());
        for (String abstractionImplName : abstractionImplNames.split(" ")) {
            try {
                Class<?> abstractionImpl = Class.forName(abstractionImplName);
                ContainerAbstraction abstraction = (ContainerAbstraction)abstractionImpl.newInstance();
                if (!abstraction.isNativeEnvironment(servletConfig)) continue;
                container.addParameter(ContainerAbstraction.class.getName(), abstractionImplName);
                String loadMonitorImplName = container.getParameter(ServerLoadMonitor.class.getName());
                if (loadMonitorImplName == null) {
                    Class<? extends ServerLoadMonitor> loadMonitorImpl = abstraction.getServerLoadMonitorImplementation();
                    container.addParameter(ServerLoadMonitor.class.getName(), loadMonitorImpl.getName());
                }
                return;
            }
            catch (Exception ex) {
                throw new ContainerConfigurationException("Exception while loading ContainerAbstraction called : " + abstractionImplName, ex);
            }
        }
        throw new ContainerConfigurationException("None of the configured ContainerAbstractions claims isNativeEnvironment=true. Implementations tested: " + abstractionImplNames);
    }

    public static void setupDefaults(DefaultContainer container) throws ContainerConfigurationException {
        container.addParameter(AccessControl.class.getName(), DefaultAccessControl.class.getName());
        container.addParameter(ConverterManager.class.getName(), DefaultConverterManager.class.getName());
        container.addParameter(CreatorManager.class.getName(), DefaultCreatorManager.class.getName());
        container.addParameter(UrlProcessor.class.getName(), UrlProcessor.class.getName());
        container.addParameter(HubFactory.HubBuilder.class.getName(), DefaultHubBuilder.class.getName());
        container.addParameter(WebContextFactory.WebContextBuilder.class.getName(), DefaultWebContextBuilder.class.getName());
        container.addParameter(ServerContextFactory.ServerContextBuilder.class.getName(), DefaultServerContextBuilder.class.getName());
        container.addParameter(AjaxFilterManager.class.getName(), DefaultAjaxFilterManager.class.getName());
        container.addParameter(Remoter.class.getName(), DefaultRemoter.class.getName());
        container.addParameter(DebugPageGenerator.class.getName(), DefaultDebugPageGenerator.class.getName());
        container.addParameter(PlainCallMarshaller.class.getName(), PlainCallMarshaller.class.getName());
        container.addParameter(HtmlCallMarshaller.class.getName(), HtmlCallMarshaller.class.getName());
        container.addParameter(ScriptSessionManager.class.getName(), DefaultScriptSessionManager.class.getName());
        container.addParameter(PageNormalizer.class.getName(), DefaultPageNormalizer.class.getName());
        container.addParameter(DownloadManager.class.getName(), InMemoryDownloadManager.class.getName());
        String abstractions = JettyContainerAbstraction.class.getName() + " " + GrizzlyContainerAbstraction.class.getName() + " " + ServletSpecContainerAbstraction.class.getName();
        container.addParameter(ContainerAbstraction.class.getName(), abstractions);
        ContainerUtil.createUrlMapping(container, "/index.html", "indexHandlerUrl", IndexHandler.class);
        ContainerUtil.createUrlMapping(container, "/engine.js", "engineHandlerUrl", EngineHandler.class);
        ContainerUtil.createUrlMapping(container, "/util.js", "utilHandlerUrl", UtilHandler.class);
        ContainerUtil.createUrlMapping(container, "/auth.js", "authHandlerUrl", AuthHandler.class);
        ContainerUtil.createUrlMapping(container, "/gi.js", "giHandlerUrl", GiHandler.class);
        ContainerUtil.createUrlMapping(container, "/webwork/DWRActionUtil.js", "webworkUtilHandlerUrl", WebworkUtilHandler.class);
        ContainerUtil.createUrlMapping(container, "/about", "aboutHandlerUrl", AboutHandler.class);
        ContainerUtil.createUrlMapping(container, "/test/", "testHandlerUrl", TestHandler.class);
        ContainerUtil.createUrlMapping(container, "/interface/", "interfaceHandlerUrl", InterfaceHandler.class);
        ContainerUtil.createUrlMapping(container, "/monitor/", "monitorHandlerUrl", MonitorHandler.class);
        ContainerUtil.createUrlMapping(container, "/download/", "downloadHandlerUrl", DownloadHandler.class);
        ContainerUtil.createUrlMapping(container, "/call/plaincall/", "plainCallHandlerUrl", PlainCallHandler.class);
        ContainerUtil.createUrlMapping(container, "/call/plainpoll/", "plainPollHandlerUrl", PlainPollHandler.class);
        ContainerUtil.createUrlMapping(container, "/call/htmlcall/", "htmlCallHandlerUrl", HtmlCallHandler.class);
        ContainerUtil.createUrlMapping(container, "/call/htmlpoll/", "htmlPollHandlerUrl", HtmlPollHandler.class);
    }

    public static void createUrlMapping(DefaultContainer container, String url, String propertyName, Class<?> handler) throws ContainerConfigurationException {
        container.addParameter("url:" + url, handler.getName());
        container.addParameter(propertyName, url);
    }

    public static void setupFromServletConfig(DefaultContainer container, ServletConfig servletConfig) throws ContainerConfigurationException {
        Enumeration en = servletConfig.getInitParameterNames();
        while (en.hasMoreElements()) {
            String name = (String)en.nextElement();
            String value = servletConfig.getInitParameter(name);
            container.addParameter(name, value);
        }
    }

    public static void prepareForWebContextFilter(ServletContext context, ServletConfig config, Container container, WebContextFactory.WebContextBuilder webContextBuilder, HttpServlet servlet) {
        context.setAttribute(Container.class.getName(), (Object)container);
        context.setAttribute(WebContextFactory.WebContextBuilder.class.getName(), (Object)webContextBuilder);
        context.setAttribute(ServletConfig.class.getName(), (Object)config);
        context.setAttribute(HttpServlet.class.getName(), (Object)servlet);
    }

    public static void configureFromSystemDwrXml(Container container) throws IOException, ParserConfigurationException, SAXException {
        DwrXmlConfigurator system = new DwrXmlConfigurator();
        system.setClassResourceName("/org/directwebremoting/dwr.xml");
        system.configure(container);
    }

    public static void configureFromDefaultDwrXml(Container container) throws IOException, ParserConfigurationException, SAXException {
        DwrXmlConfigurator local = new DwrXmlConfigurator();
        local.setServletResourceName("/WEB-INF/dwr.xml");
        local.configure(container);
    }

    public static boolean configureFromInitParams(Container container, ServletConfig servletConfig) throws IOException, ParserConfigurationException, SAXException {
        Enumeration en = servletConfig.getInitParameterNames();
        boolean foundConfig = false;
        while (en.hasMoreElements()) {
            String name = (String)en.nextElement();
            String value = servletConfig.getInitParameter(name);
            if (name.startsWith(INIT_CONFIG)) {
                foundConfig = true;
                StringTokenizer st = new StringTokenizer(value, "\n,");
                while (st.hasMoreTokens()) {
                    String fileName = st.nextToken().trim();
                    DwrXmlConfigurator local = new DwrXmlConfigurator();
                    local.setServletResourceName(fileName);
                    local.configure(container);
                }
                continue;
            }
            if (!name.equals(INIT_CUSTOM_CONFIGURATOR)) continue;
            foundConfig = true;
            try {
                Configurator configurator = LocalUtil.classNewInstance(INIT_CUSTOM_CONFIGURATOR, value, Configurator.class);
                configurator.configure(container);
                log.debug((Object)("Loaded config from: " + value));
            }
            catch (Exception ex) {
                log.warn((Object)"Failed to start custom configurator", (Throwable)ex);
            }
        }
        return foundConfig;
    }

    public static boolean configureFromAnnotations(Container container) {
        AnnotationsConfigurator configurator = new AnnotationsConfigurator();
        configurator.configure(container);
        log.debug((Object)"Java5 AnnotationsConfigurator enabled");
        return true;
    }

    public static void configure(Container container, List<Configurator> configurators) {
        for (Configurator configurator : configurators) {
            log.debug((Object)("** Adding config from " + configurator));
            configurator.configure(container);
        }
    }

    public static void configureContainerFully(Container container, ServletConfig servletConfig) throws IOException, ParserConfigurationException, SAXException {
        ContainerUtil.configureFromSystemDwrXml(container);
        boolean foundConfig = ContainerUtil.configureFromInitParams(container, servletConfig);
        boolean skip = Boolean.valueOf(servletConfig.getInitParameter(INIT_SKIP_DEFAULT));
        IOException delayedIOException = null;
        if (!foundConfig && !skip) {
            try {
                ContainerUtil.configureFromDefaultDwrXml(container);
            }
            catch (IOException ex) {
                delayedIOException = ex;
            }
        }
        if (!ContainerUtil.configureFromAnnotations(container)) {
            log.debug((Object)"Java5 AnnotationsConfigurator disabled");
            if (delayedIOException != null) {
                throw delayedIOException;
            }
        }
    }

    public static void publishContainer(Container container, ServletConfig servletConfig) {
        ServletContext servletContext = servletConfig.getServletContext();
        ArrayList<Container> containers = (ArrayList<Container>)servletContext.getAttribute(ATTRIBUTE_CONTAINER_LIST);
        if (containers == null) {
            containers = new ArrayList<Container>();
        }
        containers.add(container);
        servletContext.setAttribute(ATTRIBUTE_CONTAINER_LIST, containers);
        ServerContext serverContext = ServerContextFactory.get(servletContext);
        String name = servletConfig.getServletName();
        contextMap.put(name, serverContext);
        log.debug((Object)("Adding to contextMap, a serverContext called " + name));
        if (contextMap.containsKey(DEFAULT_SERVERCONTEXT_NAME)) {
            contextMap.remove(DEFAULT_SERVERCONTEXT_NAME);
            log.debug((Object)"Multiple instances of DWR detected.");
        } else {
            contextMap.put(DEFAULT_SERVERCONTEXT_NAME, serverContext);
        }
    }

    public static ServerContext getSingletonServerContext() {
        return contextMap.get(DEFAULT_SERVERCONTEXT_NAME);
    }

    public static List<Container> getAllPublishedContainers(ServletContext servletContext) {
        ArrayList containers = (ArrayList)servletContext.getAttribute(ATTRIBUTE_CONTAINER_LIST);
        if (containers == null) {
            containers = new ArrayList();
        }
        return containers;
    }

    public static void shutdownServerLoadMonitorsInContainerList(List<Container> containers, String title) {
        if (containers == null || containers.isEmpty()) {
            log.debug((Object)("No containers to shutdown for: " + title));
            return;
        }
        log.debug((Object)("Shutting down containers for: " + title));
        for (Container container : containers) {
            ServerLoadMonitor monitor = container.getBean(ServerLoadMonitor.class);
            monitor.shutdown();
        }
    }

    public static void debugConfig(Container container) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Container");
            log.debug((Object)("  Type: " + container.getClass().getName()));
            for (String name : container.getBeanNames()) {
                Object object = container.getBean(name);
                if (object instanceof String) {
                    log.debug((Object)("  Param: " + name + " = " + object + " (" + object.getClass().getName() + ")"));
                    continue;
                }
                log.debug((Object)("  Bean: " + name + " = " + object + " (" + object.getClass().getName() + ")"));
            }
            AccessControl accessControl = container.getBean(AccessControl.class);
            log.debug((Object)"AccessControl");
            log.debug((Object)("  Type: " + accessControl.getClass().getName()));
            AjaxFilterManager ajaxFilterManager = container.getBean(AjaxFilterManager.class);
            log.debug((Object)"AjaxFilterManager");
            log.debug((Object)("  Type: " + ajaxFilterManager.getClass().getName()));
            ConverterManager converterManager = container.getBean(ConverterManager.class);
            log.debug((Object)"ConverterManager");
            log.debug((Object)("  Type: " + converterManager.getClass().getName()));
            CreatorManager creatorManager = container.getBean(CreatorManager.class);
            log.debug((Object)"CreatorManager");
            log.debug((Object)("  Type: " + creatorManager.getClass().getName()));
            for (String creatorName : creatorManager.getCreatorNames()) {
                Creator creator = creatorManager.getCreator(creatorName);
                log.debug((Object)("  Creator: " + creatorName + " = " + creator + " (" + creator.getClass().getName() + ")"));
            }
        }
    }
}

