/*
 * Decompiled with CFR 0.152.
 */
package org.directwebremoting.impl;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import javax.servlet.ServletContext;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.directwebremoting.WebContext;
import org.directwebremoting.WebContextFactory;
import org.directwebremoting.extend.PageNormalizer;
import org.directwebremoting.util.DomUtil;
import org.directwebremoting.util.EmptyEntityResolver;
import org.directwebremoting.util.LogErrorHandler;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultPageNormalizer
implements PageNormalizer {
    private ServletContext servletContext = null;
    protected boolean normalizeIncludesQueryString = false;
    private static DocumentBuilderFactory buildFactory = null;
    protected static final Object initLock = new Object();
    private List<String> welcomeFiles;
    private static final Log log = LogFactory.getLog(DefaultPageNormalizer.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String normalizePage(String unnormalized) {
        int queryPos;
        Object object = initLock;
        synchronized (object) {
            if (this.welcomeFiles == null) {
                if (this.servletContext != null) {
                    this.welcomeFiles = DefaultPageNormalizer.getWebXmlWelcomeFileList(this.servletContext);
                } else {
                    WebContext webContext = WebContextFactory.get();
                    if (webContext == null) {
                        log.warn((Object)"Can't find ServletContext to check for <welcome-file-list> in web.xml. Assuming defaults.");
                        log.warn((Object)" - To prevent this message from happening, either call the PageNormalizer from a DWR thread");
                        log.warn((Object)" - Or seed the PageNormalizer with a ServletContext before access from outside a DWR thread");
                    } else {
                        ServletContext threadServletContext = webContext.getServletContext();
                        this.welcomeFiles = DefaultPageNormalizer.getWebXmlWelcomeFileList(threadServletContext);
                    }
                }
            }
            if (this.welcomeFiles == null) {
                log.debug((Object)"Using default welcome file list (index.[jsp|htm[l]])");
                this.welcomeFiles = DefaultPageNormalizer.getDefaultWelcomeFileList();
            }
        }
        if (unnormalized == null) {
            return null;
        }
        String normalized = unnormalized;
        if (!this.normalizeIncludesQueryString && (queryPos = normalized.indexOf(63)) != -1) {
            normalized = normalized.substring(0, queryPos);
        }
        for (String welcomeFile : this.welcomeFiles) {
            if (!normalized.endsWith(welcomeFile)) continue;
            normalized = normalized.substring(0, normalized.length() - welcomeFile.length());
            break;
        }
        return normalized;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static List<String> getWebXmlWelcomeFileList(ServletContext context) {
        try {
            InputStream in = context.getResourceAsStream("/WEB-INF/web.xml");
            if (in == null) {
                log.warn((Object)"Missing /WEB-INF/web.xml");
                return null;
            }
            Class<DefaultPageNormalizer> clazz = DefaultPageNormalizer.class;
            synchronized (DefaultPageNormalizer.class) {
                if (buildFactory == null) {
                    buildFactory = DocumentBuilderFactory.newInstance();
                    buildFactory.setValidating(false);
                }
                // ** MonitorExit[var2_3] (shouldn't be in output)
                DocumentBuilder builder = buildFactory.newDocumentBuilder();
                builder.setEntityResolver(new EmptyEntityResolver());
                builder.setErrorHandler(new LogErrorHandler());
                InputSource is = new InputSource(in);
                Document doc = builder.parse(is);
                Element webapp = doc.getDocumentElement();
                NodeList welcomeFileListNodes = webapp.getElementsByTagName("welcome-file-list");
                if (welcomeFileListNodes.getLength() == 0) {
                    log.debug((Object)"web.xml contains no <welcome-file-list> element");
                    return null;
                }
                ArrayList<String> reply = new ArrayList<String>();
                for (int i = 0; i < welcomeFileListNodes.getLength(); ++i) {
                    Element welcomeFileListNode = (Element)welcomeFileListNodes.item(i);
                    NodeList welcomeFileNodes = welcomeFileListNode.getElementsByTagName("welcome-file");
                    for (int j = 0; j < welcomeFileNodes.getLength(); ++j) {
                        Element welcomeFileNode = (Element)welcomeFileNodes.item(j);
                        String welcomeFile = DomUtil.getText(welcomeFileNode);
                        reply.add(welcomeFile);
                        log.debug((Object)("Adding welcome-file: " + welcomeFile));
                    }
                }
                return reply;
            }
        }
        catch (Exception ex) {
            log.warn((Object)"Failed to calculate welcome files from web.xml.", (Throwable)ex);
            return null;
        }
    }

    protected static List<String> getDefaultWelcomeFileList() {
        ArrayList<String> reply = new ArrayList<String>();
        reply.add("index.html");
        reply.add("index.htm");
        reply.add("index.jsp");
        return reply;
    }

    public void setWelcomeFileList(List<String> welcomeFiles) {
        this.welcomeFiles = welcomeFiles;
    }

    public void setWelcomeFiles(String welcomeFileNames) {
        StringTokenizer st = new StringTokenizer(welcomeFileNames, "\n,");
        while (st.hasMoreTokens()) {
            this.welcomeFiles.add(st.nextToken());
        }
    }

    public void setNormalizeIncludesQueryString(boolean normalizeIncludesQueryString) {
        this.normalizeIncludesQueryString = normalizeIncludesQueryString;
    }

    public void setServletContext(ServletContext servletContext) {
        this.servletContext = servletContext;
    }
}

