/*
 * Decompiled with CFR 0.152.
 */
package org.directwebremoting.json;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.directwebremoting.json.JsonValue;
import org.directwebremoting.util.JavascriptUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JsonObject
extends JsonValue
implements Map<String, JsonValue> {
    private Map<String, JsonValue> proxy = new HashMap<String, JsonValue>();

    @Override
    public String toExternalRepresentation() {
        StringBuffer output = new StringBuffer();
        output.append("{ ");
        boolean isFirst = true;
        for (Map.Entry<String, JsonValue> entry : this.proxy.entrySet()) {
            if (isFirst) {
                isFirst = false;
            } else {
                output.append(", ");
            }
            output.append('\'');
            output.append(JavascriptUtil.escapeJavaScript(entry.getKey()));
            output.append("':");
            output.append(entry.getValue().toExternalRepresentation());
        }
        output.append(" }");
        return output.toString();
    }

    @Override
    public void clear() {
        this.proxy.clear();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.proxy.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.proxy.containsValue(value);
    }

    @Override
    public Set<Map.Entry<String, JsonValue>> entrySet() {
        return this.proxy.entrySet();
    }

    @Override
    public JsonValue get(Object key) {
        return this.proxy.get(key);
    }

    @Override
    public boolean isEmpty() {
        return this.proxy.isEmpty();
    }

    @Override
    public Set<String> keySet() {
        return this.proxy.keySet();
    }

    @Override
    public JsonValue put(String key, JsonValue value) {
        return this.proxy.put(key, value);
    }

    @Override
    public void putAll(Map<? extends String, ? extends JsonValue> otherMap) {
        this.proxy.putAll(otherMap);
    }

    @Override
    public JsonValue remove(Object key) {
        return this.proxy.remove(key);
    }

    @Override
    public int size() {
        return this.proxy.size();
    }

    @Override
    public Collection<JsonValue> values() {
        return this.proxy.values();
    }

    public String toString() {
        return this.toExternalRepresentation();
    }

    @Override
    public boolean equals(Object o) {
        return ((Object)this.proxy).equals(o);
    }

    @Override
    public int hashCode() {
        return ((Object)this.proxy).hashCode();
    }
}

