/*
 * Decompiled with CFR 0.152.
 */
package org.directwebremoting.servlet;

import java.io.IOException;
import java.io.PrintWriter;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.directwebremoting.extend.Handler;
import org.directwebremoting.util.Continuation;

public class ExceptionHandler
implements Handler {
    private Exception cause;
    private static final Log log = LogFactory.getLog(ExceptionHandler.class);

    public void handle(HttpServletRequest request, HttpServletResponse response) throws IOException {
        Continuation.rethrowIfContinuation(this.cause);
        log.warn((Object)("Error: " + this.cause));
        log.debug((Object)"Debug for stack trace:", (Throwable)this.cause);
        if (this.cause instanceof SecurityException && log.isDebugEnabled()) {
            log.debug((Object)("- User Agent: " + request.getHeader("User-Agent")));
            log.debug((Object)("- Remote IP:  " + request.getRemoteAddr()));
            log.debug((Object)("- Request URL:" + request.getRequestURL()));
            log.debug((Object)("- Query:      " + request.getQueryString()));
            log.debug((Object)("- Method:     " + request.getMethod()));
        }
        try {
            response.setStatus(501);
            response.setContentType("text/html");
            PrintWriter out = response.getWriter();
            out.println(this.cause.getMessage());
        }
        catch (Exception ex) {
            log.debug((Object)("Error in error handler, the browswer probably went away: " + ex));
        }
    }

    public void setException(Exception cause) {
        this.cause = cause;
    }
}

