/*
 * Decompiled with CFR 0.152.
 */
package org.directwebremoting.spring;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.directwebremoting.WebContextFactory;
import org.directwebremoting.extend.Configurator;
import org.directwebremoting.impl.ContainerUtil;
import org.directwebremoting.impl.StartupUtil;
import org.directwebremoting.servlet.UrlProcessor;
import org.directwebremoting.spring.SpringContainer;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.context.ApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DwrSpringServlet
extends HttpServlet {
    private ApplicationContext applicationContext = null;
    private SpringContainer container;
    protected WebContextFactory.WebContextBuilder webContextBuilder;
    private boolean includeDefaultConfig = true;
    private List<Configurator> configurators = new ArrayList<Configurator>();
    private static final Log log = LogFactory.getLog(DwrSpringServlet.class);

    public void setConfigurators(List<Configurator> configurators) {
        this.configurators = configurators;
    }

    public void setIncludeDefaultConfig(boolean includeDefaultConfig) {
        this.includeDefaultConfig = includeDefaultConfig;
    }

    public void setApplicationContext(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    public void init(ServletConfig servletConfig) throws ServletException {
        super.init(servletConfig);
        ServletContext servletContext = servletConfig.getServletContext();
        try {
            ApplicationContext appContext = this.getApplicationContext(servletContext);
            this.container = new SpringContainer();
            this.container.setBeanFactory((BeanFactory)appContext);
            ContainerUtil.setupDefaultContainer(this.container, servletConfig);
            StartupUtil.initContainerBeans(servletConfig, servletContext, this.container);
            this.webContextBuilder = this.container.getBean(WebContextFactory.WebContextBuilder.class);
            ContainerUtil.prepareForWebContextFilter(servletContext, servletConfig, this.container, this.webContextBuilder, this);
            ContainerUtil.publishContainer(this.container, servletConfig);
            try {
                this.configurators.add((Configurator)appContext.getBean("__dwrConfiguration"));
            }
            catch (NoSuchBeanDefinitionException ex) {
                throw new ServletException("No DWR configuration was found in your application context, make sure to define one", (Throwable)ex);
            }
            if (this.includeDefaultConfig) {
                ContainerUtil.configureFromSystemDwrXml(this.container);
            }
            ContainerUtil.configureFromInitParams(this.container, servletConfig);
            ContainerUtil.configure(this.container, this.configurators);
        }
        catch (Exception ex) {
            log.fatal((Object)"init failed", (Throwable)ex);
            throw new ServletException((Throwable)ex);
        }
        finally {
            this.webContextBuilder.unset();
        }
    }

    protected ApplicationContext getApplicationContext(ServletContext servletContext) {
        return this.applicationContext == null ? WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)servletContext) : this.applicationContext;
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws IOException, ServletException {
        this.doPost(req, resp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        try {
            this.webContextBuilder.set(request, response, this.getServletConfig(), this.getServletContext(), this.container);
            UrlProcessor processor = this.container.getBean(UrlProcessor.class);
            processor.handle(request, response);
        }
        finally {
            this.webContextBuilder.unset();
        }
    }
}

