/*
 * Decompiled with CFR 0.152.
 */
package org.directwebremoting.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.security.Principal;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.directwebremoting.util.FakeHttpSession;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FakeHttpServletRequest
implements HttpServletRequest {
    private String characterEncoding = null;
    private Map<String, Object> attributes = new HashMap<String, Object>();
    private static final Log log = LogFactory.getLog(FakeHttpServletRequest.class);

    public String getAuthType() {
        return null;
    }

    public Cookie[] getCookies() {
        return null;
    }

    public long getDateHeader(String name) {
        return -1L;
    }

    public String getHeader(String name) {
        return null;
    }

    public Enumeration<String[]> getHeaders(String name) {
        return Collections.enumeration(Collections.emptySet());
    }

    public Enumeration<String> getHeaderNames() {
        return Collections.enumeration(Collections.emptySet());
    }

    public int getIntHeader(String name) {
        return -1;
    }

    public String getMethod() {
        log.warn((Object)"Inventing data in FakeHttpServletRequest.getMethod() to remain plausible.");
        return "GET";
    }

    public String getPathInfo() {
        return null;
    }

    public String getPathTranslated() {
        return null;
    }

    public String getContextPath() {
        log.warn((Object)"Inventing data in FakeHttpServletRequest.getContextPath() to remain plausible.");
        return "";
    }

    public String getQueryString() {
        return null;
    }

    public String getRemoteUser() {
        return null;
    }

    public boolean isUserInRole(String role) {
        return false;
    }

    public Principal getUserPrincipal() {
        return null;
    }

    public String getRequestedSessionId() {
        return null;
    }

    public String getRequestURI() {
        log.warn((Object)"Inventing data in FakeHttpServletRequest.getRequestURI() to remain plausible.");
        return "/";
    }

    public StringBuffer getRequestURL() {
        log.warn((Object)"Inventing data in FakeHttpServletRequest.getRequestURL() to remain plausible.");
        return new StringBuffer("http://localhost/");
    }

    public String getServletPath() {
        log.warn((Object)"Inventing data in FakeHttpServletRequest.getServletPath() to remain plausible.");
        return "";
    }

    public HttpSession getSession(boolean create) {
        if (!create) {
            return null;
        }
        return new FakeHttpSession();
    }

    public HttpSession getSession() {
        return null;
    }

    public boolean isRequestedSessionIdValid() {
        return false;
    }

    public boolean isRequestedSessionIdFromCookie() {
        return false;
    }

    public boolean isRequestedSessionIdFromURL() {
        return false;
    }

    @Deprecated
    public boolean isRequestedSessionIdFromUrl() {
        return false;
    }

    public Object getAttribute(String name) {
        return this.attributes.get(name);
    }

    public Enumeration<String> getAttributeNames() {
        return Collections.enumeration(this.attributes.keySet());
    }

    public String getCharacterEncoding() {
        return this.characterEncoding;
    }

    public void setCharacterEncoding(String characterEncoding) throws UnsupportedEncodingException {
        this.characterEncoding = characterEncoding;
    }

    public int getContentLength() {
        return 0;
    }

    public String getContentType() {
        log.warn((Object)"Inventing data in FakeHttpServletRequest.getContentType() to remain plausible.");
        return "text/plain";
    }

    public ServletInputStream getInputStream() throws IOException {
        return new ServletInputStream(){

            public int read() throws IOException {
                return -1;
            }
        };
    }

    public String getLocalAddr() {
        log.warn((Object)"Inventing data in FakeHttpServletRequest.getLocalAddr() to remain plausible.");
        return "127.0.0.1";
    }

    public String getLocalName() {
        log.warn((Object)"Inventing data in FakeHttpServletRequest.getLocalName() to remain plausible.");
        return "localhost";
    }

    public int getLocalPort() {
        log.warn((Object)"Inventing data in FakeHttpServletRequest.getLocalPort() to remain plausible.");
        return 80;
    }

    public String getParameter(String name) {
        return null;
    }

    public Enumeration<String> getParameterNames() {
        return Collections.enumeration(Collections.emptySet());
    }

    public String[] getParameterValues(String name) {
        return null;
    }

    public Map<String, String> getParameterMap() {
        return Collections.emptyMap();
    }

    public String getProtocol() {
        log.warn((Object)"Inventing data in FakeHttpServletRequest.getProtocol() to remain plausible.");
        return "HTTP/1.1";
    }

    public String getScheme() {
        log.warn((Object)"Inventing data in FakeHttpServletRequest.getScheme() to remain plausible.");
        return "http";
    }

    public String getServerName() {
        log.warn((Object)"Inventing data in FakeHttpServletRequest.getServerName() to remain plausible.");
        return "localhost";
    }

    public int getServerPort() {
        log.warn((Object)"Inventing data in FakeHttpServletRequest.getServerPort() to remain plausible.");
        return 80;
    }

    public BufferedReader getReader() throws IOException {
        return new BufferedReader(new StringReader(""));
    }

    public String getRemoteAddr() {
        log.warn((Object)"Inventing data in FakeHttpServletRequest.getRemoteAddr() to remain plausible.");
        return "localhost";
    }

    public String getRemoteHost() {
        log.warn((Object)"Inventing data in FakeHttpServletRequest.getRemoteHost() to remain plausible.");
        return "localhost";
    }

    public int getRemotePort() {
        log.warn((Object)"Inventing data in FakeHttpServletRequest.getRemotePort() to remain plausible.");
        return 80;
    }

    public void setAttribute(String name, Object o) {
        this.attributes.put(name, o);
    }

    public void removeAttribute(String name) {
        this.attributes.remove(name);
    }

    public Locale getLocale() {
        return Locale.getDefault();
    }

    public Enumeration<Locale> getLocales() {
        return Collections.enumeration(Arrays.asList(Locale.getDefault()));
    }

    public boolean isSecure() {
        return false;
    }

    public RequestDispatcher getRequestDispatcher(String path) {
        return new RequestDispatcher(){

            public void include(ServletRequest request, ServletResponse response) throws ServletException, IOException {
            }

            public void forward(ServletRequest request, ServletResponse response) throws ServletException, IOException {
            }
        };
    }

    @Deprecated
    public String getRealPath(String path) {
        return null;
    }
}

