/*
 * Decompiled with CFR 0.152.
 */
package org.dishevelled.bio.benchmarks;

import java.io.File;
import org.dishevelled.bio.benchmarks.Utils;
import org.dishevelled.bio.tools.DisinterleaveFastq;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.Level;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.TearDown;

@State(value=Scope.Thread)
public class DisinterleaveFastqBenchmarks {
    private File pairedFile;
    private File firstFastqFile;
    private File secondFastqFile;

    @Setup(value=Level.Invocation)
    public void setUp() throws Exception {
        this.pairedFile = File.createTempFile("disinterleaveFastqBenchmarks", ".ifq.gz");
        this.firstFastqFile = File.createTempFile("disinterleaveFastqBenchmarks", ".fq.gz");
        this.secondFastqFile = File.createTempFile("disinterleaveFastqBenchmarks", ".fq.gz");
        Utils.copyResource("NIST7035_TAAGGCGA_L002.20000.0.ifq.gz", this.pairedFile);
    }

    @TearDown(value=Level.Invocation)
    public void tearDown() {
        this.pairedFile.delete();
        this.firstFastqFile.delete();
        this.secondFastqFile.delete();
    }

    @Benchmark
    public void disinterleaveFastq() throws Exception {
        new DisinterleaveFastq(this.pairedFile, null, this.firstFastqFile, this.secondFastqFile).call();
    }
}

