/*
 * Decompiled with CFR 0.152.
 */
package org.dishevelled.bio.benchmarks;

import com.google.common.collect.ImmutableList;
import java.io.File;
import java.util.List;
import org.dishevelled.bio.benchmarks.Utils;
import org.dishevelled.bio.tools.FilterGaf;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.Level;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.TearDown;

@State(value=Scope.Thread)
public class FilterGafBenchmarks {
    private File inputGafFile;
    private File outputGafFile;

    @Setup(value=Level.Invocation)
    public void setUp() throws Exception {
        this.inputGafFile = File.createTempFile("filterGafBenchmarks", ".gaf.gz");
        this.outputGafFile = File.createTempFile("filterGafBenchmarks", ".gaf.gz");
        Utils.copyResource("A-3105.fa.gz.pggb-s3000-p70-n10-a70-K11-k8-w10000-j5000-W0-e5000.paf.gz", this.inputGafFile);
    }

    @TearDown(value=Level.Invocation)
    public void tearDown() {
        this.inputGafFile.delete();
        this.outputGafFile.delete();
    }

    @Benchmark
    public void filterGafByMappingQuality() throws Exception {
        new FilterGaf((List)ImmutableList.of((Object)new FilterGaf.MappingQualityFilter(30)), this.inputGafFile, this.outputGafFile).call();
    }
}

