/*
 * Decompiled with CFR 0.152.
 */
package org.dishevelled.bio.benchmarks;

import com.google.common.collect.ImmutableList;
import java.io.File;
import java.util.List;
import org.dishevelled.bio.benchmarks.Utils;
import org.dishevelled.bio.tools.FilterPaf;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.Level;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.TearDown;

@State(value=Scope.Thread)
public class FilterPafBenchmarks {
    private File inputPafFile;
    private File outputPafFile;

    @Setup(value=Level.Invocation)
    public void setUp() throws Exception {
        this.inputPafFile = File.createTempFile("filterPafBenchmarks", ".paf.gz");
        this.outputPafFile = File.createTempFile("filterPafBenchmarks", ".paf.gz");
        Utils.copyResource("A-3105.fa.gz.pggb-s3000-p70-n10-a70-K11-k8-w10000-j5000-W0-e5000.paf.gz", this.inputPafFile);
    }

    @TearDown(value=Level.Invocation)
    public void tearDown() {
        this.inputPafFile.delete();
        this.outputPafFile.delete();
    }

    @Benchmark
    public void filterPafByMappingQuality() throws Exception {
        new FilterPaf((List)ImmutableList.of((Object)new FilterPaf.MappingQualityFilter(30)), this.inputPafFile, this.outputPafFile).call();
    }
}

