/*
 * Decompiled with CFR 0.152.
 */
package org.dishevelled.bio.benchmarks;

import com.google.common.collect.ImmutableList;
import java.io.File;
import java.util.List;
import org.dishevelled.bio.benchmarks.Utils;
import org.dishevelled.bio.tools.FilterSam;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.Level;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.TearDown;

@State(value=Scope.Thread)
public class FilterSamBenchmarks {
    private File inputSamFile;
    private File outputSamFile;

    @Setup(value=Level.Invocation)
    public void setUp() throws Exception {
        this.inputSamFile = File.createTempFile("filterSamBenchmarks", ".sam");
        this.outputSamFile = File.createTempFile("filterSamBenchmarks", ".sam");
        Utils.copyResource("CEUTrio.HiSeq.WGS.b37.NA12878.20.21.10k.sam", this.inputSamFile);
    }

    @TearDown(value=Level.Invocation)
    public void tearDown() {
        this.inputSamFile.delete();
        this.outputSamFile.delete();
    }

    @Benchmark
    public void filterSamByMapq() throws Exception {
        new FilterSam((List)ImmutableList.of((Object)new FilterSam.MapqFilter(30)), this.inputSamFile, this.outputSamFile).call();
    }
}

