/*
 * Decompiled with CFR 0.152.
 */
package org.dishevelled.bio.benchmarks;

import htsjdk.samtools.SAMFileWriter;
import htsjdk.samtools.SAMFileWriterFactory;
import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.SamReader;
import htsjdk.samtools.SamReaderFactory;
import java.io.File;
import org.dishevelled.bio.benchmarks.Utils;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.Level;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.TearDown;

@State(value=Scope.Thread)
public class FilterSamHtsjdkBenchmarks {
    private File inputSamFile;
    private File outputSamFile;

    @Setup(value=Level.Invocation)
    public void setUp() throws Exception {
        this.inputSamFile = File.createTempFile("filterSamHtsjdkBenchmarks", ".sam");
        this.outputSamFile = File.createTempFile("filterSamHtsjdkBenchmarks", ".sam");
        Utils.copyResource("CEUTrio.HiSeq.WGS.b37.NA12878.20.21.10k.sam", this.inputSamFile);
    }

    @TearDown(value=Level.Invocation)
    public void tearDown() {
        this.inputSamFile.delete();
        this.outputSamFile.delete();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Benchmark
    public void filterSamByMapq() {
        SamReader reader = null;
        SAMFileWriter writer = null;
        try {
            reader = SamReaderFactory.makeDefault().open(this.inputSamFile);
            writer = new SAMFileWriterFactory().makeSAMOrBAMWriter(reader.getFileHeader(), true, this.outputSamFile);
            for (SAMRecord samRecord : reader) {
                if (samRecord.getMappingQuality() < 30) continue;
                writer.addAlignment(samRecord);
            }
        }
        finally {
            try {
                writer.close();
            }
            catch (Exception exception) {}
            try {
                reader.close();
            }
            catch (Exception exception) {}
        }
    }
}

