/*
 * Decompiled with CFR 0.152.
 */
package org.dishevelled.bio.benchmarks;

import com.google.common.collect.ImmutableList;
import java.io.File;
import java.util.List;
import org.dishevelled.bio.benchmarks.Utils;
import org.dishevelled.bio.tools.FilterVcf;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.Level;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.TearDown;

@State(value=Scope.Thread)
public class FilterVcfBenchmarks {
    private File inputVcfFile;
    private File outputVcfFile;

    @Setup(value=Level.Invocation)
    public void setUp() throws Exception {
        this.inputVcfFile = File.createTempFile("filterVcfBenchmarks", ".vcf.gz");
        this.outputVcfFile = File.createTempFile("filterVcfBenchmarks", ".vcf.gz");
        Utils.copyResource("HG001_GRCh38_GIAB_highconf_CG-IllFB-IllGATKHC-Ion-10X-SOLID_CHROM1-X_v.3.3.2_highconf_PGandRTGphasetransfer.10k.0.vcf.gz", this.inputVcfFile);
    }

    @TearDown(value=Level.Invocation)
    public void tearDown() {
        this.inputVcfFile.delete();
        this.outputVcfFile.delete();
    }

    @Benchmark
    public void filterVcfByQualityScore() throws Exception {
        new FilterVcf((List)ImmutableList.of((Object)new FilterVcf.QualFilter(30.0)), this.inputVcfFile, this.outputVcfFile).call();
    }
}

