/*
 * Decompiled with CFR 0.152.
 */
package org.dishevelled.bio.benchmarks;

import htsjdk.tribble.AbstractFeatureReader;
import htsjdk.tribble.FeatureCodec;
import htsjdk.tribble.readers.LineIterator;
import htsjdk.variant.variantcontext.VariantContext;
import htsjdk.variant.variantcontext.writer.Options;
import htsjdk.variant.variantcontext.writer.VariantContextWriter;
import htsjdk.variant.variantcontext.writer.VariantContextWriterBuilder;
import htsjdk.variant.vcf.VCFCodec;
import htsjdk.variant.vcf.VCFHeader;
import java.io.File;
import org.dishevelled.bio.benchmarks.Utils;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.Level;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.TearDown;

@State(value=Scope.Thread)
public class FilterVcfHtsjdkBenchmarks {
    private File inputVcfFile;
    private File outputVcfFile;

    @Setup(value=Level.Invocation)
    public void setUp() throws Exception {
        this.inputVcfFile = File.createTempFile("filterVcfHtsjdkBenchmarks", ".vcf.gz");
        this.outputVcfFile = File.createTempFile("filterVcfHtsjdkBenchmarks", ".vcf.gz");
        Utils.copyResource("HG001_GRCh38_GIAB_highconf_CG-IllFB-IllGATKHC-Ion-10X-SOLID_CHROM1-X_v.3.3.2_highconf_PGandRTGphasetransfer.10k.0.vcf.gz", this.inputVcfFile);
    }

    @TearDown(value=Level.Invocation)
    public void tearDown() {
        this.inputVcfFile.delete();
        this.outputVcfFile.delete();
    }

    private AbstractFeatureReader<VariantContext, LineIterator> createReader() throws Exception {
        return AbstractFeatureReader.getFeatureReader((String)this.inputVcfFile.getAbsolutePath(), (FeatureCodec)new VCFCodec(), (boolean)false);
    }

    private VariantContextWriter createWriter() {
        return new VariantContextWriterBuilder().setOutputFile(this.outputVcfFile).setOutputFileType(VariantContextWriterBuilder.OutputType.VCF).unsetOption(Options.INDEX_ON_THE_FLY).build();
    }

    @Benchmark
    public void filterVcfByQualityScore() throws Exception {
        try (AbstractFeatureReader<VariantContext, LineIterator> reader = this.createReader();
             VariantContextWriter writer = this.createWriter();){
            writer.writeHeader((VCFHeader)reader.getHeader());
            for (VariantContext vc : reader.iterator()) {
                if (!(vc.getPhredScaledQual() >= 30.0)) continue;
                writer.add(vc);
            }
        }
    }
}

