/*
 * Decompiled with CFR 0.152.
 */
package org.dishevelled.bio.benchmarks;

import java.io.File;
import org.dishevelled.bio.benchmarks.Utils;
import org.dishevelled.bio.tools.InterleaveFastq;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.Level;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.TearDown;

@State(value=Scope.Thread)
public class InterleaveFastqBenchmarks {
    private File firstFastqFile;
    private File secondFastqFile;
    private File pairedFile;
    private File unpairedFile;

    @Setup(value=Level.Invocation)
    public void setUp() throws Exception {
        this.firstFastqFile = File.createTempFile("interleaveFastqBenchmarks", ".fq.gz");
        this.secondFastqFile = File.createTempFile("interleaveFastqBenchmarks", ".fq.gz");
        this.pairedFile = File.createTempFile("interleaveFastqBenchmarks", ".ifq.gz");
        this.unpairedFile = File.createTempFile("interleaveFastqBenchmarks", ".fq.gz");
        Utils.copyResource("NIST7035_TAAGGCGA_L002_R1_001_trimmed.10000.0.fq.gz", this.firstFastqFile);
        Utils.copyResource("NIST7035_TAAGGCGA_L002_R2_001_trimmed.10000.0.fq.gz", this.secondFastqFile);
    }

    @TearDown(value=Level.Invocation)
    public void tearDown() {
        this.firstFastqFile.delete();
        this.secondFastqFile.delete();
        this.pairedFile.delete();
        this.unpairedFile.delete();
    }

    @Benchmark
    public void interleaveFastq() throws Exception {
        new InterleaveFastq(this.firstFastqFile, this.secondFastqFile, this.pairedFile, this.unpairedFile).call();
    }
}

