/*
 * Decompiled with CFR 0.152.
 */
package org.dishevelled.bio.benchmarks;

import java.io.File;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import org.dishevelled.bio.alignment.sam.SamAdapter;
import org.dishevelled.bio.alignment.sam.SamListener;
import org.dishevelled.bio.alignment.sam.SamReader;
import org.dishevelled.bio.alignment.sam.SamRecord;
import org.dishevelled.bio.benchmarks.Utils;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.Level;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.TearDown;

@State(value=Scope.Thread)
public class SamCollectBenchmarks {
    private File inputSamFile;
    private final int EXPECTED_COUNT = 10000;

    @Setup(value=Level.Invocation)
    public void setUp() throws Exception {
        this.inputSamFile = File.createTempFile("samCollectBenchmarks", ".sam");
        Utils.copyResource("CEUTrio.HiSeq.WGS.b37.NA12878.20.21.10k.sam", this.inputSamFile);
    }

    @TearDown(value=Level.Invocation)
    public void tearDown() {
        this.inputSamFile.delete();
    }

    @Benchmark
    public void collectSamSmallCapacityArrayList() throws Exception {
        Collect collect = new Collect(new ArrayList<SamRecord>());
        SamReader.streamRecords((File)this.inputSamFile, (SamListener)collect);
        int count = 0;
        for (SamRecord record : collect.records()) {
            ++count;
        }
        if (count < 10000) {
            throw new Exception("incorrect count, " + count);
        }
    }

    @Benchmark
    public void collectSamLargeCapacityArrayList() throws Exception {
        Collect collect = new Collect(new ArrayList<SamRecord>(10000000));
        SamReader.streamRecords((File)this.inputSamFile, (SamListener)collect);
        int count = 0;
        for (SamRecord record : collect.records()) {
            ++count;
        }
        if (count < 10000) {
            throw new Exception("incorrect count, " + count);
        }
    }

    @Benchmark
    public void collectSamLinkedList() throws Exception {
        Collect collect = new Collect(new LinkedList<SamRecord>());
        SamReader.streamRecords((File)this.inputSamFile, (SamListener)collect);
        int count = 0;
        for (SamRecord record : collect.records()) {
            ++count;
        }
        if (count < 10000) {
            throw new Exception("incorrect count, " + count);
        }
    }

    @Benchmark
    public void collectSamAppendOnlyLinkedList() throws Exception {
        Collect collect = new Collect(new AppendOnlyLinkedList<SamRecord>());
        SamReader.streamRecords((File)this.inputSamFile, (SamListener)collect);
        int count = 0;
        for (SamRecord record : collect.records()) {
            ++count;
        }
        if (count < 10000) {
            throw new Exception("incorrect count, " + count);
        }
    }

    private static final class Collect
    extends SamAdapter {
        private final Collection<SamRecord> records;

        private Collect(Collection<SamRecord> records) {
            this.records = records;
        }

        public boolean record(SamRecord record) {
            this.records.add(record);
            return true;
        }

        Collection<SamRecord> records() {
            return this.records;
        }
    }

    private static class AppendOnlyLinkedList<E>
    extends AbstractCollection<E> {
        private Node<E> head = null;
        private Node<E> tail = null;

        private AppendOnlyLinkedList() {
        }

        @Override
        public boolean add(E value) {
            if (this.head == null) {
                this.head = new Node<E>(value);
            } else if (this.tail == null) {
                this.tail = new Node<E>(value);
                this.head.setNext(this.tail);
            } else {
                Node<E> current = new Node<E>(value);
                this.tail.setNext(current);
                this.tail = current;
            }
            return true;
        }

        @Override
        public Iterator<E> iterator() {
            return new AppendOnlyIterator();
        }

        @Override
        public int size() {
            int size = 0;
            Iterator<E> it = this.iterator();
            while (it.hasNext()) {
                it.next();
                ++size;
            }
            return size;
        }

        private class Node<E> {
            private final E value;
            private Node<E> next;

            Node(E value) {
                this.value = value;
            }

            E value() {
                return this.value;
            }

            Node<E> next() {
                return this.next;
            }

            void setNext(Node<E> next) {
                this.next = next;
            }
        }

        private class AppendOnlyIterator
        implements Iterator<E> {
            private Node<E> current;

            AppendOnlyIterator() {
                this.current = AppendOnlyLinkedList.this.head;
            }

            @Override
            public boolean hasNext() {
                return this.current != null;
            }

            @Override
            public E next() {
                if (this.current == null) {
                    return null;
                }
                Object value = this.current.value();
                this.current = this.current.next();
                return value;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        }
    }
}

