/*
 * Decompiled with CFR 0.152.
 */
package org.dishevelled.bio.benchmarks;

import htsjdk.tribble.AbstractFeatureReader;
import htsjdk.tribble.FeatureCodec;
import htsjdk.tribble.readers.LineIterator;
import htsjdk.variant.variantcontext.VariantContext;
import htsjdk.variant.variantcontext.writer.Options;
import htsjdk.variant.variantcontext.writer.VariantContextWriter;
import htsjdk.variant.variantcontext.writer.VariantContextWriterBuilder;
import htsjdk.variant.vcf.VCFCodec;
import htsjdk.variant.vcf.VCFHeader;
import java.io.File;

public final class runFilterVcfHtsjdkOnce {
    private static AbstractFeatureReader<VariantContext, LineIterator> createReader(File inputVcfFile) {
        return AbstractFeatureReader.getFeatureReader((String)inputVcfFile.getAbsolutePath(), (FeatureCodec)new VCFCodec(), (boolean)false);
    }

    private static VariantContextWriter createWriter(File outputVcfFile) {
        return new VariantContextWriterBuilder().setOutputFile(outputVcfFile).setOutputFileType(VariantContextWriterBuilder.OutputType.VCF).unsetOption(Options.INDEX_ON_THE_FLY).build();
    }

    private static void filterVcfByQualityScore() throws Exception {
        File inputVcfFile = new File("src/main/resources/org/dishevelled/bio/benchmarks/HG001_GRCh38_GIAB_highconf_CG-IllFB-IllGATKHC-Ion-10X-SOLID_CHROM1-X_v.3.3.2_highconf_PGandRTGphasetransfer.10k.0.vcf.gz");
        File outputVcfFile = new File("filtered.vcf.gz");
        try (AbstractFeatureReader<VariantContext, LineIterator> reader = runFilterVcfHtsjdkOnce.createReader(inputVcfFile);
             VariantContextWriter writer = runFilterVcfHtsjdkOnce.createWriter(outputVcfFile);){
            writer.writeHeader((VCFHeader)reader.getHeader());
            for (VariantContext vc : reader.iterator()) {
                if (!(vc.getPhredScaledQual() >= 30.0)) continue;
                writer.add(vc);
            }
        }
    }

    public static void main(String[] args) throws Exception {
        long t = System.nanoTime();
        runFilterVcfHtsjdkOnce.filterVcfByQualityScore();
        System.out.println("took " + (System.nanoTime() - t));
    }
}

