/*
 * Decompiled with CFR 0.152.
 */
package org.dishevelled.bio.sequence;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.nio.ByteBuffer;

public final class Sequences {
    public static String decode(ByteBuffer bytes, int length) throws IOException {
        Preconditions.checkNotNull((Object)bytes);
        Preconditions.checkArgument((length >= 0 ? 1 : 0) != 0, (Object)"length must be at least 0");
        StringBuilder sb = new StringBuilder(length);
        Sequences.decode(bytes, length, sb);
        return sb.toString();
    }

    private static char toChar(byte b) {
        switch (b) {
            case 0: {
                return 'T';
            }
            case 1: {
                return 'C';
            }
            case 2: {
                return 'A';
            }
            case 3: {
                return 'G';
            }
        }
        throw new IllegalArgumentException("invalid bits " + b);
    }

    public static <T extends Appendable> T decode(ByteBuffer bytes, int length, T appendable) throws IOException {
        Preconditions.checkNotNull((Object)bytes);
        Preconditions.checkArgument((length >= 0 ? 1 : 0) != 0, (Object)"length must be at least 0");
        Preconditions.checkNotNull(appendable);
        for (int i = 0; i < length; i += 4) {
            byte b = bytes.get();
            byte base0 = (byte)(b >> 6 & 3);
            byte base1 = (byte)(b >> 4 & 3);
            byte base2 = (byte)(b >> 2 & 3);
            byte base3 = (byte)(b & 3);
            appendable.append(Sequences.toChar(base0));
            if (i + 1 < length) {
                appendable.append(Sequences.toChar(base1));
            }
            if (i + 2 < length) {
                appendable.append(Sequences.toChar(base2));
            }
            if (i + 3 >= length) continue;
            appendable.append(Sequences.toChar(base3));
        }
        return appendable;
    }

    public static ByteBuffer encode(String sequence) {
        Preconditions.checkNotNull((Object)sequence);
        return Sequences.encode(sequence, ByteBuffer.allocate(sequence.length() / 4 + 1));
    }

    private static byte toByte(char c) {
        switch (c) {
            case 'T': 
            case 't': {
                return 0;
            }
            case 'C': 
            case 'c': {
                return 1;
            }
            case 'A': 
            case 'a': {
                return 2;
            }
            case 'G': 
            case 'g': {
                return 3;
            }
        }
        throw new IllegalArgumentException("invalid symbol " + c);
    }

    public static ByteBuffer encode(String sequence, ByteBuffer bytes) {
        Preconditions.checkNotNull((Object)sequence);
        Preconditions.checkNotNull((Object)bytes);
        bytes.mark();
        int length = sequence.length();
        for (int i = 0; i < length; i += 4) {
            byte base0 = Sequences.toByte(sequence.charAt(i));
            byte base1 = i + 1 < length ? Sequences.toByte(sequence.charAt(i + 1)) : (byte)0;
            byte base2 = i + 2 < length ? Sequences.toByte(sequence.charAt(i + 2)) : (byte)0;
            byte base3 = i + 3 < length ? Sequences.toByte(sequence.charAt(i + 3)) : (byte)0;
            bytes.put((byte)((base0 << 6) + (base1 << 4) + (base2 << 2) + base3));
        }
        bytes.reset();
        return bytes;
    }

    public static String decodeWithNs(ByteBuffer bytes, int length) throws IOException {
        Preconditions.checkNotNull((Object)bytes);
        Preconditions.checkArgument((length >= 0 ? 1 : 0) != 0, (Object)"length must be at least 0");
        StringBuilder sb = new StringBuilder(length);
        Sequences.decodeWithNs(bytes, length, sb);
        return sb.toString();
    }

    private static char nibbleToChar(byte b) {
        switch (b) {
            case 0: {
                return 'T';
            }
            case 1: {
                return 'C';
            }
            case 2: {
                return 'A';
            }
            case 3: {
                return 'G';
            }
            case 4: {
                return 'N';
            }
        }
        throw new IllegalArgumentException("invalid bits " + b);
    }

    public static <T extends Appendable> T decodeWithNs(ByteBuffer bytes, int length, T appendable) throws IOException {
        Preconditions.checkNotNull((Object)bytes);
        Preconditions.checkArgument((length >= 0 ? 1 : 0) != 0, (Object)"length must be at least 0");
        Preconditions.checkNotNull(appendable);
        for (int i = 0; i < length; i += 2) {
            byte b = bytes.get();
            byte base0 = (byte)(b >> 4 & 7);
            byte base1 = (byte)(b & 7);
            appendable.append(Sequences.nibbleToChar(base0));
            if (i + 1 >= length) continue;
            appendable.append(Sequences.nibbleToChar(base1));
        }
        return appendable;
    }

    public static ByteBuffer encodeWithNs(String sequence) {
        Preconditions.checkNotNull((Object)sequence);
        return Sequences.encodeWithNs(sequence, ByteBuffer.allocate(sequence.length() / 2 + 1));
    }

    private static byte nibbleToByte(char c) {
        switch (c) {
            case 'T': 
            case 't': {
                return 0;
            }
            case 'C': 
            case 'c': {
                return 1;
            }
            case 'A': 
            case 'a': {
                return 2;
            }
            case 'G': 
            case 'g': {
                return 3;
            }
            case 'N': 
            case 'n': {
                return 4;
            }
        }
        throw new IllegalArgumentException("invalid symbol " + c);
    }

    public static ByteBuffer encodeWithNs(String sequence, ByteBuffer bytes) {
        Preconditions.checkNotNull((Object)sequence);
        Preconditions.checkNotNull((Object)bytes);
        bytes.mark();
        int length = sequence.length();
        for (int i = 0; i < length; i += 2) {
            byte base0 = Sequences.nibbleToByte(sequence.charAt(i));
            byte base1 = i + 1 < length ? Sequences.nibbleToByte(sequence.charAt(i + 1)) : (byte)0;
            bytes.put((byte)((base0 << 4) + base1));
        }
        bytes.reset();
        return bytes;
    }

    public static String decodeWithAmbiguity(ByteBuffer bytes, int length) throws IOException {
        Preconditions.checkNotNull((Object)bytes);
        Preconditions.checkArgument((length >= 0 ? 1 : 0) != 0, (Object)"length must be at least 0");
        StringBuilder sb = new StringBuilder(length);
        Sequences.decodeWithAmbiguity(bytes, length, sb);
        return sb.toString();
    }

    public static <T extends Appendable> T decodeWithAmbiguity(ByteBuffer bytes, int length, T appendable) throws IOException {
        Preconditions.checkNotNull((Object)bytes);
        Preconditions.checkArgument((length >= 0 ? 1 : 0) != 0, (Object)"length must be at least 0");
        Preconditions.checkNotNull(appendable);
        for (int i = 0; i < length; i += 2) {
            byte b = bytes.get();
            byte base0 = (byte)(b >> 4 & 0xF);
            byte base1 = (byte)(b & 0xF);
            appendable.append(Sequences.ambiguousNibbleToChar(base0));
            if (i + 1 >= length) continue;
            appendable.append(Sequences.ambiguousNibbleToChar(base1));
        }
        return appendable;
    }

    private static char ambiguousNibbleToChar(byte b) {
        switch (b) {
            case 0: {
                return '=';
            }
            case 1: {
                return 'A';
            }
            case 2: {
                return 'C';
            }
            case 3: {
                return 'M';
            }
            case 4: {
                return 'G';
            }
            case 5: {
                return 'R';
            }
            case 6: {
                return 'S';
            }
            case 7: {
                return 'V';
            }
            case 8: {
                return 'T';
            }
            case 9: {
                return 'W';
            }
            case 10: {
                return 'Y';
            }
            case 11: {
                return 'H';
            }
            case 12: {
                return 'K';
            }
            case 13: {
                return 'D';
            }
            case 14: {
                return 'B';
            }
            case 15: {
                return 'N';
            }
        }
        throw new IllegalArgumentException("invalid bits " + b);
    }

    public static ByteBuffer encodeWithAmbiguity(String sequence) {
        Preconditions.checkNotNull((Object)sequence);
        return Sequences.encodeWithAmbiguity(sequence, ByteBuffer.allocate(sequence.length() / 2 + 1));
    }

    public static ByteBuffer encodeWithAmbiguity(String sequence, ByteBuffer bytes) {
        Preconditions.checkNotNull((Object)sequence);
        Preconditions.checkNotNull((Object)bytes);
        bytes.mark();
        int length = sequence.length();
        for (int i = 0; i < length; i += 2) {
            byte base0 = Sequences.ambiguousNibbleToByte(sequence.charAt(i));
            byte base1 = i + 1 < length ? Sequences.ambiguousNibbleToByte(sequence.charAt(i + 1)) : (byte)0;
            bytes.put((byte)((base0 << 4) + base1));
        }
        bytes.reset();
        return bytes;
    }

    private static byte ambiguousNibbleToByte(char c) {
        switch (c) {
            case '=': {
                return 0;
            }
            case 'A': 
            case 'a': {
                return 1;
            }
            case 'C': 
            case 'c': {
                return 2;
            }
            case 'M': 
            case 'm': {
                return 3;
            }
            case 'G': 
            case 'g': {
                return 4;
            }
            case 'R': 
            case 'r': {
                return 5;
            }
            case 'S': 
            case 's': {
                return 6;
            }
            case 'V': 
            case 'v': {
                return 7;
            }
            case 'T': 
            case 't': {
                return 8;
            }
            case 'W': 
            case 'w': {
                return 9;
            }
            case 'Y': 
            case 'y': {
                return 10;
            }
            case 'H': 
            case 'h': {
                return 11;
            }
            case 'K': 
            case 'k': {
                return 12;
            }
            case 'D': 
            case 'd': {
                return 13;
            }
            case 'B': 
            case 'b': {
                return 14;
            }
        }
        return 15;
    }

    static String formatBits(byte b) {
        return String.format("%8s", Integer.toBinaryString(b & 0xFF)).replace(' ', '0');
    }
}

