/*
 * Decompiled with CFR 0.152.
 */
package org.dishevelled.commandline;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.dishevelled.commandline.Argument;

public final class ArgumentList
implements Iterable<Argument<?>> {
    private final Set<String> shortNames = new HashSet<String>();
    private final Set<String> longNames = new HashSet<String>();
    private final List<Argument<?>> arguments = new ArrayList();

    public ArgumentList() {
    }

    public ArgumentList(Argument<?> ... arguments) {
        this();
        if (arguments == null) {
            throw new IllegalArgumentException("arguments must not be null");
        }
        this.addAll(Arrays.asList(arguments));
    }

    public ArgumentList(Collection<Argument<?>> arguments) {
        this();
        this.addAll(arguments);
    }

    public boolean add(Argument<?> argument) {
        if (argument == null) {
            throw new IllegalArgumentException("argument must not be null");
        }
        if (this.shortNames.contains(argument.getShortName())) {
            throw new IllegalArgumentException("this argument list already contains an argument with short name " + argument.getShortName());
        }
        if (this.longNames.contains(argument.getLongName())) {
            throw new IllegalArgumentException("this argument list already contains an argument with long name " + argument.getLongName());
        }
        if (this.arguments.add(argument)) {
            this.shortNames.add(argument.getShortName());
            this.longNames.add(argument.getLongName());
            return true;
        }
        return false;
    }

    public boolean addAll(Collection<Argument<?>> arguments) {
        if (arguments == null) {
            throw new IllegalArgumentException("arguments must not be null");
        }
        boolean result = false;
        for (Argument<?> a : arguments) {
            result = this.add(a) || result;
        }
        return result;
    }

    public int size() {
        return this.arguments.size();
    }

    @Override
    public Iterator<Argument<?>> iterator() {
        return Collections.unmodifiableList(this.arguments).iterator();
    }
}

