/*
 * Decompiled with CFR 0.152.
 */
package org.dishevelled.commandline;

import org.dishevelled.commandline.Argument;
import org.dishevelled.commandline.ArgumentList;
import org.dishevelled.commandline.CommandLine;
import org.dishevelled.commandline.CommandLineParseException;

public final class CommandLineParser {
    private CommandLineParser() {
    }

    public static void parse(CommandLine commandLine, ArgumentList arguments) throws CommandLineParseException {
        if (commandLine == null) {
            throw new IllegalArgumentException("commandLine must not be null");
        }
        if (arguments == null) {
            throw new IllegalArgumentException("arguments must not be null");
        }
        try {
            while (commandLine.hasNext()) {
                String s = commandLine.next();
                for (Argument<?> a : arguments) {
                    a.visit(s, commandLine);
                }
            }
        }
        catch (Exception e) {
            throw new CommandLineParseException(e);
        }
        for (Argument<?> a : arguments) {
            if (!a.isRequired() || a.wasFound()) continue;
            StringBuffer sb = new StringBuffer();
            sb.append("required argument -");
            sb.append(a.getShortName());
            sb.append(", --");
            sb.append(a.getLongName());
            sb.append(" not found");
            throw new CommandLineParseException(sb.toString());
        }
    }
}

