/*
 * Decompiled with CFR 0.152.
 */
package org.dishevelled.commandline;

import org.dishevelled.commandline.Argument;
import org.dishevelled.commandline.CommandLine;

public final class Switch
implements Argument<Boolean> {
    private final String shortName;
    private final String longName;
    private final String description;
    private boolean found;

    public Switch(String shortName, String longName, String description) {
        this.shortName = shortName;
        this.longName = longName;
        this.description = description;
        this.found = false;
    }

    @Override
    public void visit(String current, CommandLine commandLine) throws Exception {
        if (("-" + this.getShortName()).equals(current) || ("--" + this.getLongName()).equals(current)) {
            this.found = true;
        }
    }

    @Override
    public String getShortName() {
        return this.shortName;
    }

    @Override
    public String getLongName() {
        return this.longName;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public boolean isRequired() {
        return false;
    }

    @Override
    public boolean wasFound() {
        return this.found;
    }

    @Override
    public Boolean getValue() {
        return this.found;
    }

    @Override
    public Boolean getValue(Boolean defaultValue) {
        return this.found ? Boolean.TRUE : defaultValue;
    }
}

