/*
 * Decompiled with CFR 0.152.
 */
package org.dishevelled.commandline;

import java.io.OutputStream;
import java.io.PrintWriter;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Arrays;
import org.dishevelled.commandline.Argument;
import org.dishevelled.commandline.ArgumentList;
import org.dishevelled.commandline.CommandLine;
import org.dishevelled.commandline.Switch;

public final class Usage {
    private Usage() {
    }

    public static void usage(String message, Throwable cause, CommandLine commandLine, ArgumentList arguments, OutputStream out) {
        Usage.usage(null, message, cause, commandLine, arguments, out);
    }

    public static void usage(String header, String message, Throwable cause, CommandLine commandLine, ArgumentList arguments, OutputStream out) {
        if (out == null) {
            throw new IllegalArgumentException("out must not be null");
        }
        PrintWriter pw = new PrintWriter(out, false);
        if (header != null) {
            pw.println(header);
            pw.print("\n");
        }
        pw.println("usage:");
        if (message != null) {
            pw.println(message);
            pw.print("\n");
        }
        if (cause != null) {
            cause.printStackTrace(pw);
            pw.print("\n");
        }
        if (arguments != null && arguments.size() > 0) {
            pw.println("arguments:");
            for (Argument<?> a : arguments) {
                StringBuffer sb = new StringBuffer();
                sb.append("   -");
                sb.append(a.getShortName());
                sb.append(", --");
                sb.append(a.getLongName());
                if (!(a instanceof Switch)) {
                    sb.append(" ");
                    ParameterizedType parameterizedType = (ParameterizedType)a.getClass().getGenericSuperclass();
                    Type[] types = parameterizedType.getActualTypeArguments();
                    sb.append(Arrays.asList(types));
                }
                sb.append("  ");
                sb.append(a.getDescription());
                if (a.isRequired()) {
                    sb.append(" [required]");
                } else {
                    sb.append(" [optional]");
                }
                pw.println(sb.toString());
            }
        }
        pw.flush();
    }
}

