/*
 * Decompiled with CFR 0.152.
 */
package org.dishevelled.commandline.argument;

import org.dishevelled.commandline.Argument;
import org.dishevelled.commandline.CommandLine;

public abstract class AbstractArgument<E>
implements Argument<E> {
    private final String shortName;
    private final String longName;
    private final String description;
    private final boolean required;
    private E value;
    private boolean found;

    protected AbstractArgument(String shortName, String longName, String description, boolean required) {
        this.shortName = shortName;
        this.longName = longName;
        this.description = description;
        this.required = required;
        this.found = false;
    }

    @Override
    public final void visit(String current, CommandLine commandLine) throws Exception {
        if (this.isArgumentString(current)) {
            this.found = true;
            return;
        }
        if (this.isValueString(current) && commandLine.hasPrevious()) {
            commandLine.previous();
            if (commandLine.hasPrevious()) {
                String previous = commandLine.previous();
                if (this.isArgumentString(previous)) {
                    this.value = this.convert(current);
                }
                commandLine.next();
            }
            commandLine.next();
        }
    }

    protected boolean isArgumentString(String s) {
        return ("-" + this.getShortName()).equals(s) || ("--" + this.getLongName()).equals(s);
    }

    protected boolean isValueString(String s) {
        if ("-".equals(s)) {
            return true;
        }
        if (s.startsWith("-")) {
            char next = s.charAt(1);
            return Character.isDigit(next);
        }
        return true;
    }

    protected abstract E convert(String var1) throws Exception;

    @Override
    public final String getShortName() {
        return this.shortName;
    }

    @Override
    public final String getLongName() {
        return this.longName;
    }

    @Override
    public final String getDescription() {
        return this.description;
    }

    @Override
    public final boolean isRequired() {
        return this.required;
    }

    @Override
    public final boolean wasFound() {
        return this.found;
    }

    @Override
    public final E getValue() {
        return this.value;
    }

    @Override
    public final E getValue(E defaultValue) {
        return this.found ? this.value : defaultValue;
    }

    public final boolean equals(Object o) {
        return super.equals(o);
    }

    public final int hashCode() {
        return super.hashCode();
    }
}

