/*
 * Decompiled with CFR 0.152.
 */
package org.dishevelled.commandline.argument;

import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.apache.commons.lang.StringUtils;
import org.dishevelled.commandline.argument.AbstractArgument;

public final class BooleanListArgument
extends AbstractArgument<List<Boolean>> {
    public BooleanListArgument(String shortName, String longName, String description, boolean required) {
        super(shortName, longName, description, required);
    }

    @Override
    protected List<Boolean> convert(String s) throws Exception {
        ArrayList<Boolean> list = new ArrayList<Boolean>();
        StringTokenizer st = new StringTokenizer(s, ",");
        while (st.hasMoreTokens()) {
            String token = StringUtils.stripToEmpty((String)st.nextToken());
            if ("true".equalsIgnoreCase(token)) {
                list.add(Boolean.TRUE);
                continue;
            }
            if ("false".equalsIgnoreCase(token)) {
                list.add(Boolean.FALSE);
                continue;
            }
            if ("t".equalsIgnoreCase(token)) {
                list.add(Boolean.TRUE);
                continue;
            }
            if ("f".equalsIgnoreCase(token)) {
                list.add(Boolean.FALSE);
                continue;
            }
            if ("1".equalsIgnoreCase(token)) {
                list.add(Boolean.TRUE);
                continue;
            }
            if ("0".equalsIgnoreCase(token)) {
                list.add(Boolean.FALSE);
                continue;
            }
            throw new Exception("could not parse " + token + " into a Boolean");
        }
        return list;
    }
}

