/*
 * Decompiled with CFR 0.152.
 */
package org.dishevelled.commandline.argument;

import java.util.HashSet;
import java.util.Set;
import java.util.StringTokenizer;
import org.apache.commons.lang.StringUtils;
import org.dishevelled.commandline.argument.AbstractArgument;

public final class BooleanSetArgument
extends AbstractArgument<Set<Boolean>> {
    public BooleanSetArgument(String shortName, String longName, String description, boolean required) {
        super(shortName, longName, description, required);
    }

    @Override
    protected Set<Boolean> convert(String s) throws Exception {
        HashSet<Boolean> set = new HashSet<Boolean>();
        StringTokenizer st = new StringTokenizer(s, ",");
        while (st.hasMoreTokens()) {
            String token = StringUtils.stripToEmpty((String)st.nextToken());
            if ("true".equalsIgnoreCase(token)) {
                set.add(Boolean.TRUE);
                continue;
            }
            if ("false".equalsIgnoreCase(token)) {
                set.add(Boolean.FALSE);
                continue;
            }
            if ("t".equalsIgnoreCase(token)) {
                set.add(Boolean.TRUE);
                continue;
            }
            if ("f".equalsIgnoreCase(token)) {
                set.add(Boolean.FALSE);
                continue;
            }
            if ("1".equalsIgnoreCase(token)) {
                set.add(Boolean.TRUE);
                continue;
            }
            if ("0".equalsIgnoreCase(token)) {
                set.add(Boolean.FALSE);
                continue;
            }
            throw new Exception("could not parse " + token + " into a Boolean");
        }
        return set;
    }
}

