/*
 * Decompiled with CFR 0.152.
 */
package org.dishevelled.commandline.argument;

import java.io.File;
import java.net.URI;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.dishevelled.commandline.argument.AbstractArgument;

public final class PathArgument
extends AbstractArgument<Path> {
    public PathArgument(String shortName, String longName, String description, boolean required) {
        super(shortName, longName, description, required);
    }

    @Override
    protected Path convert(String s) throws Exception {
        return PathArgument.convertPath(s);
    }

    static Path convertPath(String s) throws Exception {
        if (s == null || "".equals(s)) {
            return null;
        }
        URI uri = URI.create(s);
        String scheme = uri.getScheme();
        if (scheme == null || "".equals(scheme)) {
            return new File(s).toPath();
        }
        return Paths.get(uri);
    }
}

