/*
 * Decompiled with CFR 0.152.
 */
package org.dishevelled.iconbundle.tools;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.io.OutputStream;
import java.util.List;
import org.dishevelled.commandline.Argument;
import org.dishevelled.commandline.ArgumentList;
import org.dishevelled.commandline.CommandLine;
import org.dishevelled.commandline.CommandLineParseException;
import org.dishevelled.commandline.CommandLineParser;
import org.dishevelled.commandline.Switch;
import org.dishevelled.commandline.Usage;
import org.dishevelled.commandline.argument.DoubleArgument;
import org.dishevelled.commandline.argument.FloatArgument;
import org.dishevelled.commandline.argument.IntegerListArgument;
import org.dishevelled.commandline.argument.StringArgument;
import org.dishevelled.iconbundle.IconBundle;
import org.dishevelled.iconbundle.impl.ShapeIconBundle;
import org.dishevelled.iconbundle.tools.ShowAllVariants;

public final class ShapeVariants {
    public static void main(String[] args) {
        CommandLine commandLine = null;
        ArgumentList arguments = null;
        try {
            commandLine = new CommandLine(args);
            DoubleArgument x = new DoubleArgument("x", "x", "x coordinate", true);
            DoubleArgument y = new DoubleArgument("y", "y", "y coordinate", true);
            DoubleArgument w = new DoubleArgument("w", "width", "width", true);
            DoubleArgument h = new DoubleArgument("h", "height", "height", true);
            StringArgument s = new StringArgument("s", "shape", "shape, one of { ellipse, rectangle }", true);
            FloatArgument t = new FloatArgument("t", "stroke", "stroke", true);
            IntegerListArgument f = new IntegerListArgument("f", "fill-color", "fill color, in int RGBA format:  R,G,B,A", true);
            IntegerListArgument k = new IntegerListArgument("k", "stroke-color", "stroke color, in int RGBA format:  R,G,B,A", true);
            StringArgument o = new StringArgument("o", "output", "output file name", true);
            Switch b = new Switch("b", "draw-borders", "true to draw borders");
            arguments = new ArgumentList(new Argument[]{x, y, w, h, s, t, f, k, o, b});
            CommandLineParser.parse((CommandLine)commandLine, (ArgumentList)arguments);
            RectangularShape shape = null;
            if ("ellipse".equals(s.getValue())) {
                shape = new Ellipse2D.Double((Double)x.getValue(), (Double)y.getValue(), (Double)w.getValue(), (Double)h.getValue());
            } else if ("rectangle".equals(s.getValue())) {
                shape = new Rectangle2D.Double((Double)x.getValue(), (Double)y.getValue(), (Double)w.getValue(), (Double)h.getValue());
            } else {
                throw new CommandLineParseException("shape " + (String)s.getValue() + " not recognized");
            }
            BasicStroke stroke = new BasicStroke(((Float)t.getValue()).floatValue());
            Color fillColor = new Color((Integer)((List)f.getValue()).get(0), (Integer)((List)f.getValue()).get(1), (Integer)((List)f.getValue()).get(2), (Integer)((List)f.getValue()).get(3));
            Color strokeColor = new Color((Integer)((List)k.getValue()).get(0), (Integer)((List)k.getValue()).get(1), (Integer)((List)k.getValue()).get(2), (Integer)((List)k.getValue()).get(3));
            ShapeIconBundle iconBundle = new ShapeIconBundle((Shape)shape, (Stroke)stroke, (Paint)fillColor, (Paint)strokeColor);
            ShowAllVariants sav = new ShowAllVariants((IconBundle)iconBundle, (String)o.getValue(), (Boolean)b.getValue());
            sav.run();
        }
        catch (CommandLineParseException e) {
            Usage.usage((String)"java -jar shape-variants.jar [args]\n\nShape Variants", (Throwable)e, (CommandLine)commandLine, arguments, (OutputStream)System.err);
        }
    }
}

