/*
 * Decompiled with CFR 0.152.
 */
package org.dishevelled.iconbundle.tools;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import javax.imageio.ImageIO;
import org.dishevelled.iconbundle.IconBundle;
import org.dishevelled.iconbundle.IconSize;
import org.dishevelled.iconbundle.IconState;
import org.dishevelled.iconbundle.IconTextDirection;

public final class ShowAllVariants
implements Runnable {
    private String fileName;
    private boolean drawBorders;
    private IconBundle iconBundle;

    public ShowAllVariants(IconBundle iconBundle, String fileName, boolean drawBorders) {
        this.iconBundle = iconBundle;
        this.fileName = fileName;
        this.drawBorders = drawBorders;
    }

    public void run() {
        int w = 0;
        int h = 0;
        int maxHeight = 0;
        int horizontalGap = 4;
        int verticalGap = 4;
        for (IconSize size : IconSize.VALUES) {
            w += size.getWidth();
            w += horizontalGap;
            if (size.getHeight() <= maxHeight) continue;
            maxHeight = size.getHeight();
        }
        h = IconState.VALUES.size() * (maxHeight + verticalGap);
        BufferedImage image = new BufferedImage(w *= IconTextDirection.VALUES.size(), h, 2);
        Graphics2D g = image.createGraphics();
        int x = 0;
        int y = 0;
        maxHeight = 0;
        for (IconState state : IconState.VALUES) {
            for (IconSize size : IconSize.VALUES) {
                for (IconTextDirection direction : IconTextDirection.VALUES) {
                    g.drawImage(this.iconBundle.getImage(null, direction, state, size), x, y, Color.WHITE, null);
                    if (this.drawBorders) {
                        g.setPaint(Color.BLACK);
                        g.drawRect(x, y, size.getWidth(), size.getHeight());
                    }
                    x += size.getWidth();
                    x += horizontalGap;
                    if (size.getHeight() <= maxHeight) continue;
                    maxHeight = size.getHeight();
                }
            }
            x = 0;
            y += maxHeight;
            y += verticalGap;
            maxHeight = 0;
        }
        try {
            ImageIO.write((RenderedImage)image, "png", new File(this.fileName));
        }
        catch (Exception e) {
            // empty catch block
        }
    }
}

