/*
 * Decompiled with CFR 0.152.
 */
package org.dishevelled.layout.examples;

import java.awt.Component;
import java.awt.LayoutManager;
import javax.swing.Box;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import org.dishevelled.layout.LabelFieldLayout;

public final class LabelFieldLayoutExample
implements Runnable {
    @Override
    public void run() {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception exception) {
            // empty catch block
        }
        JFrame finalSpacing = new JFrame("Final spacing example");
        finalSpacing.setContentPane(this.createFinalSpacingPane());
        finalSpacing.setDefaultCloseOperation(3);
        finalSpacing.setBounds(120, 120, 380, 480);
        JFrame finalWideField = new JFrame("Final wide field example");
        finalWideField.setContentPane(this.createFinalWideFieldPane());
        finalWideField.setDefaultCloseOperation(3);
        finalWideField.setBounds(200, 200, 380, 480);
        finalSpacing.setVisible(true);
        finalWideField.setVisible(true);
    }

    private JPanel createFinalSpacingPane() {
        JPanel contentPane = new JPanel();
        LabelFieldLayout l = new LabelFieldLayout();
        contentPane.setLayout((LayoutManager)l);
        contentPane.setBorder(new EmptyBorder(11, 11, 11, 11));
        contentPane.add((Component)new JLabel("Label label 0:"), l.labelLabel());
        contentPane.add((Component)new JLabel("Label field 0"), l.labelField());
        l.nextLine();
        contentPane.add((Component)new JLabel("Label label 1:"), l.labelLabel());
        contentPane.add((Component)new JLabel("Label field 1"), l.labelField());
        l.nextLine();
        contentPane.add((Component)new JLabel("Label label 2:"), l.labelLabel());
        contentPane.add((Component)new JLabel("Label field 2"), l.labelField());
        l.nextLine();
        contentPane.add((Component)new JLabel("Normal label 0:"), l.normalLabel());
        contentPane.add((Component)new JTextField("Normal field 0"), l.normalField());
        l.nextLine();
        contentPane.add((Component)new JLabel("Normal label 1:"), l.normalLabel());
        contentPane.add((Component)new JTextField("Normal field 1"), l.normalField());
        l.nextLine();
        contentPane.add(Box.createVerticalStrut(12), l.spacing());
        l.nextLine();
        contentPane.add((Component)new JLabel("Wide label"), l.wideLabel());
        l.nextLine();
        contentPane.add(Box.createGlue(), l.finalSpacing());
        return contentPane;
    }

    private JPanel createFinalWideFieldPane() {
        JPanel contentPane = new JPanel();
        LabelFieldLayout l = new LabelFieldLayout();
        contentPane.setLayout((LayoutManager)l);
        contentPane.setBorder(new EmptyBorder(11, 11, 11, 11));
        contentPane.add((Component)new JLabel("Label label 0:"), l.labelLabel());
        contentPane.add((Component)new JLabel("Label field 0"), l.labelField());
        l.nextLine();
        contentPane.add((Component)new JLabel("Label label 1:"), l.labelLabel());
        contentPane.add((Component)new JLabel("Label field 1"), l.labelField());
        l.nextLine();
        contentPane.add((Component)new JLabel("Label label 2:"), l.labelLabel());
        contentPane.add((Component)new JLabel("Label field 2"), l.labelField());
        l.nextLine();
        contentPane.add((Component)new JLabel("Normal label 0:"), l.normalLabel());
        contentPane.add((Component)new JTextField("Normal field 0"), l.normalField());
        l.nextLine();
        contentPane.add((Component)new JLabel("Normal label 1:"), l.normalLabel());
        contentPane.add((Component)new JTextField("Normal field 1"), l.normalField());
        l.nextLine();
        contentPane.add(Box.createVerticalStrut(12), l.spacing());
        l.nextLine();
        contentPane.add((Component)new JLabel("Wide label"), l.wideLabel());
        l.nextLine();
        contentPane.add(Box.createVerticalStrut(12), l.spacing());
        l.nextLine();
        contentPane.add((Component)new JLabel("Final wide field:"), l.wideLabel());
        l.nextLine();
        JList<Object> list = new JList<Object>(new Object[]{"Final wide field A", "Final wide field B", "Final wide field C"});
        contentPane.add((Component)new JScrollPane(list), l.finalWideField());
        return contentPane;
    }

    public static void main(String[] args) {
        SwingUtilities.invokeLater(new LabelFieldLayoutExample());
    }
}

