/*
 * Decompiled with CFR 0.152.
 */
package org.dishevelled.piccolo.physics;

import java.awt.geom.Point2D;
import java.util.HashMap;
import java.util.Map;
import org.dishevelled.multimap.BinaryKeyMap;
import org.dishevelled.multimap.impl.BinaryKeyMaps;
import org.piccolo2d.PNode;
import org.piccolo2d.activities.PActivity;
import org.piccolo2d.util.PBounds;
import traer.physics.Attraction;
import traer.physics.Particle;
import traer.physics.ParticleSystem;
import traer.physics.Spring;

public class ParticleSystemActivity
extends PActivity {
    private final ParticleSystem particleSystem = new ParticleSystem();
    private final BinaryKeyMap<PNode, PNode, Attraction> attractions = BinaryKeyMaps.createBinaryKeyMap();
    private final Map<PNode, Particle> particles = new HashMap<PNode, Particle>();
    private final BinaryKeyMap<PNode, PNode, Spring> springs = BinaryKeyMaps.createBinaryKeyMap();

    public ParticleSystemActivity(long duration) {
        this(duration, 20L, System.currentTimeMillis());
    }

    public ParticleSystemActivity(long duration, long stepRate, long startTime) {
        super(duration, stepRate, startTime);
    }

    public void setDrag(float drag) {
        this.particleSystem.setDrag(drag);
    }

    public void setGravity(float gravity) {
        this.particleSystem.setGravity(gravity);
    }

    public void createParticle(PNode node, float mass) {
        if (node == null) {
            throw new IllegalArgumentException("node must not be null");
        }
        PBounds fullBounds = node.getFullBoundsReference();
        float x = (float)fullBounds.getX();
        float y = (float)fullBounds.getY();
        Particle particle = this.particleSystem.makeParticle(mass, x, y, 1.0f);
        this.particles.put(node, particle);
    }

    public Point2D getVelocity(PNode node) {
        return this.getVelocity(node, new Point2D.Float(0.0f, 0.0f));
    }

    public Point2D getVelocity(PNode node, Point2D velocity) {
        this.checkParticleArgs(node);
        if (velocity == null) {
            throw new IllegalArgumentException("velocity must not be null");
        }
        Particle particle = this.particles.get(node);
        velocity.setLocation(particle.velocity().x(), particle.velocity().y());
        return velocity;
    }

    public void setVelocity(PNode node, float x, float y) {
        this.checkParticleArgs(node);
        this.particles.get(node).velocity().set(x, y, 0.0f);
    }

    public void setVelocity(PNode node, Point2D velocity) {
        this.checkParticleArgs(node);
        if (velocity == null) {
            throw new IllegalArgumentException("velocity must not be null");
        }
        this.particles.get(node).velocity().set((float)velocity.getX(), (float)velocity.getY(), 0.0f);
    }

    public float getParticleMass(PNode node) {
        this.checkParticleArgs(node);
        return this.particles.get(node).mass();
    }

    public void setParticleMass(PNode node, float mass) {
        this.checkParticleArgs(node);
        this.particles.get(node).setMass(mass);
    }

    public void clamp(PNode node) {
        this.checkParticleArgs(node);
        this.particles.get(node).makeFixed();
    }

    public void release(PNode node) {
        this.checkParticleArgs(node);
        this.particles.get(node).makeFree();
    }

    public void createSpring(PNode source, PNode target, float strength, float damping, float restLength) {
        if (source == null) {
            throw new IllegalArgumentException("source node must not be null");
        }
        if (target == null) {
            throw new IllegalArgumentException("target node must not be null");
        }
        if (!this.particles.containsKey(source)) {
            throw new IllegalArgumentException("no particle exists for source node " + source);
        }
        if (!this.particles.containsKey(target)) {
            throw new IllegalArgumentException("no particle exists for target node " + target);
        }
        Spring spring = this.particleSystem.makeSpring(this.particles.get(source), this.particles.get(target), strength, damping, restLength);
        this.springs.put((Object)source, (Object)target, (Object)spring);
    }

    public void enableSpring(PNode source, PNode target) {
        this.checkSpringArgs(source, target);
        ((Spring)this.springs.get((Object)source, (Object)target)).turnOn();
    }

    public void disableSpring(PNode source, PNode target) {
        this.checkSpringArgs(source, target);
        ((Spring)this.springs.get((Object)source, (Object)target)).turnOff();
    }

    public float getSpringRestLength(PNode source, PNode target) {
        this.checkSpringArgs(source, target);
        return ((Spring)this.springs.get((Object)source, (Object)target)).restLength();
    }

    public void setSpringRestLength(PNode source, PNode target, float restLength) {
        this.checkSpringArgs(source, target);
        ((Spring)this.springs.get((Object)source, (Object)target)).setRestLength(restLength);
    }

    public float getSpringStrength(PNode source, PNode target) {
        this.checkSpringArgs(source, target);
        return ((Spring)this.springs.get((Object)source, (Object)target)).strength();
    }

    public void setSpringStrength(PNode source, PNode target, float strength) {
        this.checkSpringArgs(source, target);
        ((Spring)this.springs.get((Object)source, (Object)target)).setStrength(strength);
    }

    public float getSpringDamping(PNode source, PNode target) {
        this.checkSpringArgs(source, target);
        return ((Spring)this.springs.get((Object)source, (Object)target)).damping();
    }

    public void setSpringDamping(PNode source, PNode target, float damping) {
        this.checkSpringArgs(source, target);
        ((Spring)this.springs.get((Object)source, (Object)target)).setDamping(damping);
    }

    public void createAttraction(PNode source, PNode target, float strength, float minimumDistance) {
        if (source == null) {
            throw new IllegalArgumentException("source node must not be null");
        }
        if (target == null) {
            throw new IllegalArgumentException("target node must not be null");
        }
        if (!this.particles.containsKey(source)) {
            throw new IllegalArgumentException("no particle exists for source node " + source);
        }
        if (!this.particles.containsKey(target)) {
            throw new IllegalArgumentException("no particle exists for target node " + target);
        }
        Attraction attraction = this.particleSystem.makeAttraction(this.particles.get(source), this.particles.get(target), strength, minimumDistance);
        this.attractions.put((Object)source, (Object)target, (Object)attraction);
    }

    public void enableAttraction(PNode source, PNode target) {
        this.checkAttractionArgs(source, target);
        ((Attraction)this.attractions.get((Object)source, (Object)target)).turnOn();
    }

    public void disableAttraction(PNode source, PNode target) {
        this.checkAttractionArgs(source, target);
        ((Attraction)this.attractions.get((Object)source, (Object)target)).turnOff();
    }

    public float getAttractionStrength(PNode source, PNode target) {
        this.checkAttractionArgs(source, target);
        return ((Attraction)this.attractions.get((Object)source, (Object)target)).getStrength();
    }

    public void setAttractionStrength(PNode source, PNode target, float strength) {
        this.checkAttractionArgs(source, target);
        ((Attraction)this.attractions.get((Object)source, (Object)target)).setStrength(strength);
    }

    public float getAttractionMinimumDistance(PNode source, PNode target) {
        this.checkAttractionArgs(source, target);
        return ((Attraction)this.attractions.get((Object)source, (Object)target)).getMinimumDistance();
    }

    public void setAttractionMinimumDistance(PNode source, PNode target, float minimumDistance) {
        this.checkAttractionArgs(source, target);
        ((Attraction)this.attractions.get((Object)source, (Object)target)).setMinimumDistance(minimumDistance);
    }

    protected void activityStep(long elapsedTime) {
        super.activityStep(elapsedTime);
        this.particleSystem.tick();
        for (Map.Entry<PNode, Particle> entry : this.particles.entrySet()) {
            PNode node = entry.getKey();
            Particle particle = entry.getValue();
            if (particle.isFree()) {
                node.setOffset((double)particle.position().x(), (double)particle.position().y());
                continue;
            }
            PBounds fullBounds = node.getFullBoundsReference();
            particle.position().set((float)fullBounds.getX(), (float)fullBounds.getY(), 0.0f);
        }
    }

    protected void activityFinished() {
        super.activityFinished();
        this.attractions.clear();
        this.particles.clear();
        this.springs.clear();
        this.particleSystem.clear();
    }

    private void checkParticleArgs(PNode node) {
        if (node == null) {
            throw new IllegalArgumentException("node must not be null");
        }
        Particle particle = this.particles.get(node);
        if (particle == null) {
            throw new IllegalArgumentException("no particle exists for node " + node);
        }
    }

    private void checkSpringArgs(PNode source, PNode target) {
        if (source == null) {
            throw new IllegalArgumentException("source node must not be null");
        }
        if (target == null) {
            throw new IllegalArgumentException("target node must not be null");
        }
        if (!this.springs.containsKey((Object)source, (Object)target)) {
            throw new IllegalArgumentException("no spring exists between source node " + source + " and target node " + target);
        }
    }

    private void checkAttractionArgs(PNode source, PNode target) {
        if (source == null) {
            throw new IllegalArgumentException("source node must not be null");
        }
        if (target == null) {
            throw new IllegalArgumentException("target node must not be null");
        }
        if (!this.attractions.containsKey((Object)source, (Object)target)) {
            throw new IllegalArgumentException("no attraction exists between source node " + source + " and target node " + target);
        }
    }
}

