/*
 * Decompiled with CFR 0.152.
 */
package org.dishevelled.piccolo.sprite.examples;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import javax.imageio.ImageIO;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import org.dishevelled.piccolo.sprite.Animation;
import org.dishevelled.piccolo.sprite.LoopedFramesAnimation;
import org.dishevelled.piccolo.sprite.SingleFrameAnimation;
import org.dishevelled.piccolo.sprite.Sprite;
import org.piccolo2d.PCanvas;
import org.piccolo2d.PLayer;
import org.piccolo2d.PNode;

public class SpriteExample
extends JPanel
implements Runnable {
    public SpriteExample() {
        PCanvas canvas = new PCanvas();
        canvas.setDefaultRenderQuality(1);
        canvas.setAnimatingRenderQuality(1);
        canvas.setInteractingRenderQuality(1);
        Image f = SpriteExample.loadImage("f");
        SingleFrameAnimation fAnimation = new SingleFrameAnimation(f);
        final Sprite fSprite = new Sprite((Animation)fAnimation);
        fSprite.setBounds(0.0, 0.0, 64.0, 64.0);
        fSprite.offset(100.0, 100.0);
        Image b = SpriteExample.loadImage("b");
        Image a = SpriteExample.loadImage("a");
        Image r = SpriteExample.loadImage("r");
        List<Image> bar = Arrays.asList(b, a, r);
        LoopedFramesAnimation barAnimation = new LoopedFramesAnimation(bar);
        final Sprite barSprite = new Sprite((Animation)barAnimation);
        barSprite.setBounds(0.0, 0.0, 64.0, 64.0);
        barSprite.offset(200.0, 100.0);
        PLayer layer = canvas.getLayer();
        layer.addChild((PNode)fSprite);
        layer.addChild((PNode)barSprite);
        Timer timer = new Timer(333, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                fSprite.advance();
                barSprite.advance();
            }
        });
        timer.setRepeats(true);
        timer.start();
        this.setLayout(new BorderLayout());
        this.add("Center", (Component)canvas);
    }

    @Override
    public void run() {
        JFrame f = new JFrame("Sprite Example");
        f.setContentPane(this);
        f.setDefaultCloseOperation(3);
        f.setBounds(100, 100, 400, 400);
        f.setVisible(true);
    }

    private static Image loadImage(String name) {
        BufferedImage image = null;
        try {
            image = ImageIO.read(SpriteExample.class.getResource(name + ".png"));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return image;
    }

    public static void main(String[] args) {
        SwingUtilities.invokeLater(new SpriteExample());
    }
}

