/*
 * Decompiled with CFR 0.152.
 */
package org.dishevelled.piccolo.sprite;

import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.imageio.ImageIO;
import org.dishevelled.piccolo.sprite.LoopedFramesAnimation;
import org.dishevelled.piccolo.sprite.MultipleFramesAnimation;
import org.dishevelled.piccolo.sprite.SingleFrameAnimation;

public final class Animations {
    private Animations() {
    }

    public static SingleFrameAnimation createAnimation(InputStream image) throws IOException {
        BufferedImage bufferedImage = ImageIO.read(image);
        return Animations.createAnimation(bufferedImage);
    }

    public static SingleFrameAnimation createAnimation(File image) throws IOException {
        BufferedImage bufferedImage = ImageIO.read(image);
        return Animations.createAnimation(bufferedImage);
    }

    public static SingleFrameAnimation createAnimation(URL image) throws IOException {
        BufferedImage bufferedImage = ImageIO.read(image);
        return Animations.createAnimation(bufferedImage);
    }

    public static SingleFrameAnimation createAnimation(Image image) {
        return new SingleFrameAnimation(image);
    }

    public static MultipleFramesAnimation createAnimation(String baseImage, String suffix, int frames) throws IOException {
        return new MultipleFramesAnimation(Animations.createFrameList(baseImage, suffix, frames));
    }

    public static MultipleFramesAnimation createAnimation(File baseImage, String suffix, int frames) throws IOException {
        return new MultipleFramesAnimation(Animations.createFrameList(baseImage, suffix, frames));
    }

    public static MultipleFramesAnimation createAnimation(URL baseImage, String suffix, int frames) throws IOException {
        return new MultipleFramesAnimation(Animations.createFrameList(baseImage, suffix, frames));
    }

    public static LoopedFramesAnimation createLoopedAnimation(String baseImage, String suffix, int frames) throws IOException {
        return new LoopedFramesAnimation(Animations.createFrameList(baseImage, suffix, frames));
    }

    public static LoopedFramesAnimation createLoopedAnimation(File baseImage, String suffix, int frames) throws IOException {
        return new LoopedFramesAnimation(Animations.createFrameList(baseImage, suffix, frames));
    }

    public static LoopedFramesAnimation createLoopedAnimation(URL baseImage, String suffix, int frames) throws IOException {
        return new LoopedFramesAnimation(Animations.createFrameList(baseImage, suffix, frames));
    }

    public static MultipleFramesAnimation createAnimation(InputStream spriteSheet, int x, int y, int width, int height, int frames) throws IOException {
        return new MultipleFramesAnimation(Animations.createFrameList(spriteSheet, x, y, width, height, frames));
    }

    public static MultipleFramesAnimation createAnimation(File spriteSheet, int x, int y, int width, int height, int frames) throws IOException {
        return new MultipleFramesAnimation(Animations.createFrameList(spriteSheet, x, y, width, height, frames));
    }

    public static MultipleFramesAnimation createAnimation(URL spriteSheet, int x, int y, int width, int height, int frames) throws IOException {
        return new MultipleFramesAnimation(Animations.createFrameList(spriteSheet, x, y, width, height, frames));
    }

    public static MultipleFramesAnimation createAnimation(BufferedImage spriteSheet, int x, int y, int width, int height, int frames) {
        return new MultipleFramesAnimation(Animations.createFrameList(spriteSheet, x, y, width, height, frames));
    }

    public static LoopedFramesAnimation createLoopedAnimation(InputStream spriteSheet, int x, int y, int width, int height, int frames) throws IOException {
        return new LoopedFramesAnimation(Animations.createFrameList(spriteSheet, x, y, width, height, frames));
    }

    public static LoopedFramesAnimation createLoopedAnimation(File spriteSheet, int x, int y, int width, int height, int frames) throws IOException {
        return new LoopedFramesAnimation(Animations.createFrameList(spriteSheet, x, y, width, height, frames));
    }

    public static LoopedFramesAnimation createLoopedAnimation(URL spriteSheet, int x, int y, int width, int height, int frames) throws IOException {
        return new LoopedFramesAnimation(Animations.createFrameList(spriteSheet, x, y, width, height, frames));
    }

    public static LoopedFramesAnimation createLoopedAnimation(BufferedImage spriteSheet, int x, int y, int width, int height, int frames) {
        return new LoopedFramesAnimation(Animations.createFrameList(spriteSheet, x, y, width, height, frames));
    }

    public static MultipleFramesAnimation createAnimation(List<Image> images) {
        return new MultipleFramesAnimation(images);
    }

    public static LoopedFramesAnimation createLoopedAnimation(List<Image> images) {
        return new LoopedFramesAnimation(images);
    }

    public static List<Image> createFrameList(String baseImage, String suffix, int frames) throws IOException {
        if (baseImage == null) {
            throw new IllegalArgumentException("baseImage must not be null");
        }
        List<Image> frameList = null;
        try {
            frameList = Animations.createFrameList(new URL(baseImage), suffix, frames);
        }
        catch (MalformedURLException e) {
            frameList = Animations.createFrameList(new File(baseImage), suffix, frames);
        }
        return frameList;
    }

    public static List<Image> createFrameList(File baseImage, String suffix, int frames) throws IOException {
        if (baseImage == null) {
            throw new IllegalArgumentException("baseImage must not be null");
        }
        int leadingZeros = frames / 10 + 1;
        String format = "%s%0" + leadingZeros + "d%s";
        ArrayList<BufferedImage> images = new ArrayList<BufferedImage>(frames);
        for (int frame = 0; frame < frames; ++frame) {
            File file = new File(String.format(format, baseImage.getPath(), frame, suffix));
            BufferedImage image = ImageIO.read(file);
            images.add(image);
        }
        return Collections.unmodifiableList(images);
    }

    public static List<Image> createFrameList(URL baseImage, String suffix, int frames) throws IOException {
        if (baseImage == null) {
            throw new IllegalArgumentException("baseImage must not be null");
        }
        int leadingZeros = frames / 10 + 1;
        String format = "%s%0" + leadingZeros + "d%s";
        ArrayList<BufferedImage> images = new ArrayList<BufferedImage>(frames);
        for (int frame = 0; frame < frames; ++frame) {
            URL url = new URL(String.format(format, baseImage.getPath(), frame, suffix));
            BufferedImage image = ImageIO.read(url);
            images.add(image);
        }
        return Collections.unmodifiableList(images);
    }

    public static List<Image> createFrameList(InputStream spriteSheet, int x, int y, int width, int height, int frames) throws IOException {
        BufferedImage bufferedImage = ImageIO.read(spriteSheet);
        return Animations.createFrameList(bufferedImage, x, y, width, height, frames);
    }

    public static List<Image> createFrameList(File spriteSheet, int x, int y, int width, int height, int frames) throws IOException {
        BufferedImage bufferedImage = ImageIO.read(spriteSheet);
        return Animations.createFrameList(bufferedImage, x, y, width, height, frames);
    }

    public static List<Image> createFrameList(URL spriteSheet, int x, int y, int width, int height, int frames) throws IOException {
        BufferedImage bufferedImage = ImageIO.read(spriteSheet);
        return Animations.createFrameList(bufferedImage, x, y, width, height, frames);
    }

    public static List<Image> createFrameList(BufferedImage spriteSheet, int x, int y, int width, int height, int frames) {
        if (spriteSheet == null) {
            throw new IllegalArgumentException("spriteSheet must not be null");
        }
        ArrayList<BufferedImage> images = new ArrayList<BufferedImage>(frames);
        for (int frame = 0; frame < frames; ++frame) {
            BufferedImage subimage = spriteSheet.getSubimage(x + frame * width, y, width, height);
            images.add(subimage);
        }
        return Collections.unmodifiableList(images);
    }

    public static BufferedImage createSpriteSheet(List<Image> frameImages) {
        if (frameImages == null) {
            throw new IllegalArgumentException("frameImages must not be null");
        }
        int width = 0;
        int height = 0;
        for (Image image : frameImages) {
            if (image.getWidth(null) > width) {
                width = image.getWidth(null);
            }
            if (image.getHeight(null) <= height) continue;
            height = image.getHeight(null);
        }
        BufferedImage spriteSheet = new BufferedImage(width * frameImages.size(), height, 2);
        Graphics2D graphics = spriteSheet.createGraphics();
        graphics.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        int size = frameImages.size();
        for (int i = 0; i < size; ++i) {
            Image image = frameImages.get(i);
            int x = width * i + width / 2 - image.getWidth(null) / 2;
            int y = height / 2 - image.getHeight(null) / 2;
            graphics.drawImage(image, x, y, null);
        }
        graphics.dispose();
        return spriteSheet;
    }

    public static BufferedImage createSpriteSheet(String baseImage, String suffix, int frames) throws IOException {
        return Animations.createSpriteSheet(Animations.createFrameList(baseImage, suffix, frames));
    }

    public static BufferedImage createSpriteSheet(File baseImage, String suffix, int frames) throws IOException {
        return Animations.createSpriteSheet(Animations.createFrameList(baseImage, suffix, frames));
    }

    public static BufferedImage createSpriteSheet(URL baseImage, String suffix, int frames) throws IOException {
        return Animations.createSpriteSheet(Animations.createFrameList(baseImage, suffix, frames));
    }

    public static List<Image> flipHorizontally(List<Image> frameImages) {
        if (frameImages == null) {
            throw new IllegalArgumentException("frameImages must not be null");
        }
        int width = 0;
        int height = 0;
        for (Image image : frameImages) {
            if (image.getWidth(null) > width) {
                width = image.getWidth(null);
            }
            if (image.getHeight(null) <= height) continue;
            height = image.getHeight(null);
        }
        BufferedImage spriteSheet = new BufferedImage(width * frameImages.size(), height, 2);
        Graphics2D graphics = spriteSheet.createGraphics();
        graphics.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        int size = frameImages.size();
        for (int i = 0; i < size; ++i) {
            Image image = frameImages.get(i);
            double cx = (double)image.getWidth(null) / 2.0;
            double cy = (double)image.getHeight(null) / 2.0;
            double x = (double)(width * i) + (double)width / 2.0 - cx;
            double y = (double)height / 2.0 - cy;
            AffineTransform rotate = new AffineTransform();
            rotate.translate(cx, cy);
            rotate.concatenate(new AffineTransform(new double[]{1.0, 0.0, 0.0, -1.0}));
            rotate.translate(-cx, -cy);
            graphics.setTransform(rotate);
            graphics.drawImage(image, (int)x, (int)y, null);
        }
        graphics.dispose();
        return Animations.createFrameList(spriteSheet, 0, 0, width, height, frameImages.size());
    }

    public static List<Image> flipVertically(List<Image> frameImages) {
        if (frameImages == null) {
            throw new IllegalArgumentException("frameImages must not be null");
        }
        int width = 0;
        int height = 0;
        for (Image image : frameImages) {
            if (image.getWidth(null) > width) {
                width = image.getWidth(null);
            }
            if (image.getHeight(null) <= height) continue;
            height = image.getHeight(null);
        }
        BufferedImage spriteSheet = new BufferedImage(width * frameImages.size(), height, 2);
        Graphics2D graphics = spriteSheet.createGraphics();
        graphics.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        int size = frameImages.size();
        for (int i = 0; i < size; ++i) {
            Image image = frameImages.get(i);
            double cx = (double)image.getWidth(null) / 2.0;
            double cy = (double)image.getHeight(null) / 2.0;
            double x = (double)(width * i) + (double)width / 2.0 - cx;
            double y = (double)height / 2.0 - cy;
            AffineTransform rotate = new AffineTransform();
            rotate.translate(cx, cy);
            rotate.concatenate(new AffineTransform(new double[]{-1.0, 0.0, 0.0, 1.0}));
            rotate.translate(-cx, -cy);
            graphics.setTransform(rotate);
            graphics.drawImage(image, (int)x, (int)y, null);
        }
        graphics.dispose();
        return Animations.createFrameList(spriteSheet, 0, 0, width, height, frameImages.size());
    }

    public static List<Image> rotate(BufferedImage image, int steps) {
        if (image == null) {
            throw new IllegalArgumentException("image must not be null");
        }
        int width = image.getWidth(null);
        int height = image.getHeight(null);
        int size = Math.max(width, height);
        BufferedImage spriteSheet = new BufferedImage(size * steps, size, 2);
        Graphics2D graphics = spriteSheet.createGraphics();
        graphics.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        double x = (double)width / 2.0;
        double y = (double)height / 2.0;
        double r = 2.0 / (double)steps * Math.PI;
        for (int i = 0; i < steps; ++i) {
            AffineTransform rotate = new AffineTransform();
            rotate.translate(size * i, 0.0);
            rotate.rotate((double)i * r, x, y);
            graphics.drawRenderedImage(image, rotate);
        }
        graphics.dispose();
        return Animations.createFrameList(spriteSheet, 0, 0, size, size, steps);
    }
}

