/*
 * Decompiled with CFR 0.152.
 */
package org.dishevelled.piccolo.sprite;

import java.awt.Image;
import java.util.ArrayList;
import java.util.List;
import org.dishevelled.piccolo.sprite.Animation;

public final class MultipleFramesAnimation
implements Animation {
    private int index;
    private List<Image> frames;

    public MultipleFramesAnimation(List<Image> frames) {
        if (frames == null) {
            throw new IllegalArgumentException("frames must not be null");
        }
        if (frames.size() < 1) {
            throw new IllegalArgumentException("frames must contain at least one frame");
        }
        this.index = 0;
        this.frames = new ArrayList<Image>(frames);
    }

    public void reset() {
        this.index = 0;
    }

    @Override
    public boolean advance() {
        this.index = Math.min(this.index + 1, this.frames.size() - 1);
        return true;
    }

    @Override
    public Image getCurrentFrame() {
        return this.frames.get(this.index);
    }
}

