/*
 * Decompiled with CFR 0.152.
 */
package org.dishevelled.piccolo.sprite;

import java.awt.Graphics2D;
import java.awt.Image;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.dishevelled.piccolo.sprite.Animation;
import org.piccolo2d.PNode;
import org.piccolo2d.util.PBounds;
import org.piccolo2d.util.PPaintContext;

public class Sprite
extends PNode {
    private int skipped;
    private final int frameSkip;
    private Animation currentAnimation;
    private final Set<Animation> animations;

    public Sprite(Animation animation) {
        this(animation, Collections.singleton(animation));
    }

    public Sprite(Animation currentAnimation, Set<Animation> animations) {
        this(currentAnimation, animations, 0);
    }

    public Sprite(Animation currentAnimation, Set<Animation> animations, int frameSkip) {
        if (currentAnimation == null) {
            throw new IllegalArgumentException("currentAnimation must not be null");
        }
        if (animations == null) {
            throw new IllegalArgumentException("animations must not be null");
        }
        if (animations.size() < 1) {
            throw new IllegalArgumentException("animations must contain at least one animation");
        }
        this.animations = new HashSet<Animation>(animations);
        this.frameSkip = frameSkip;
        this.setCurrentAnimation(currentAnimation);
    }

    public final void advance() {
        if (this.skipped < this.frameSkip) {
            ++this.skipped;
        } else {
            if (this.currentAnimation.advance()) {
                this.repaint();
            }
            this.skipped = 0;
        }
    }

    public final int getFrameSkip() {
        return this.frameSkip;
    }

    public final Animation getCurrentAnimation() {
        return this.currentAnimation;
    }

    public final void setCurrentAnimation(Animation currentAnimation) {
        if (currentAnimation == null) {
            throw new IllegalArgumentException("currentAnimation must not be null");
        }
        if (!this.animations.contains(currentAnimation)) {
            throw new IllegalArgumentException("currentAnimation must be contained in animations");
        }
        Animation oldCurrentAnimation = this.currentAnimation;
        this.currentAnimation = currentAnimation;
        this.firePropertyChange(-1, "currentAnimation", oldCurrentAnimation, currentAnimation);
    }

    public final Set<Animation> getAnimations() {
        return Collections.unmodifiableSet(this.animations);
    }

    public final void addAnimation(Animation animation) {
        this.animations.add(animation);
    }

    public final void removeAnimation(Animation animation) {
        if (this.animations.size() == 1 && this.animations.contains(animation)) {
            throw new IllegalStateException("must not remove the last animation from animations");
        }
        if (this.currentAnimation.equals(animation)) {
            throw new IllegalStateException("must not remove the current animation");
        }
        this.animations.remove(animation);
    }

    public final void paint(PPaintContext paintContext) {
        Graphics2D g = paintContext.getGraphics();
        Image currentFrame = this.currentAnimation.getCurrentFrame();
        PBounds bounds = this.getBoundsReference();
        double w = currentFrame.getWidth(null);
        double h = currentFrame.getHeight(null);
        g.translate(bounds.getX(), bounds.getY());
        g.scale(bounds.getWidth() / w, bounds.getHeight() / h);
        g.drawImage(currentFrame, 0, 0, null);
        g.scale(w / bounds.getWidth(), h / bounds.getHeight());
        g.translate(-1.0 * bounds.getX(), -1.0 * bounds.getY());
    }
}

