/*
 * Decompiled with CFR 0.152.
 */
package org.dishevelled.swarm;

import cern.colt.matrix.DoubleMatrix1D;
import cern.colt.matrix.DoubleMatrix3D;
import cern.colt.matrix.impl.DenseDoubleMatrix1D;
import cern.colt.matrix.impl.DenseDoubleMatrix3D;
import java.util.Iterator;
import org.dishevelled.swarm.Particle;
import org.dishevelled.swarm.ParticleSwarm;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class ParticleSwarmImpl
implements ParticleSwarm {
    private final int particles;
    private final int dimensions;
    private final DoubleMatrix3D swarm;
    private final DoubleMatrix1D fitness;
    private final DoubleMatrix1D socialMemory;
    private final double[] array;
    private static final int SLICES = 3;
    private static final int POSITION_SLICE = 0;
    private static final int VELOCITY_SLICE = 1;
    private static final int COGNITIVE_MEMORY_SLICE = 2;

    ParticleSwarmImpl(int particles, int dimensions) {
        if (particles < 1) {
            throw new IllegalArgumentException("particles must be at least one");
        }
        if (dimensions < 1) {
            throw new IllegalArgumentException("dimensions must be at least one");
        }
        this.particles = particles;
        this.dimensions = dimensions;
        this.swarm = new DenseDoubleMatrix3D(3, particles, dimensions);
        this.fitness = new DenseDoubleMatrix1D(particles);
        this.socialMemory = new DenseDoubleMatrix1D(dimensions);
        this.array = new double[dimensions];
    }

    @Override
    public int getParticles() {
        return this.particles;
    }

    @Override
    public int getDimensions() {
        return this.dimensions;
    }

    double[] getPosition(int particle) {
        this.swarm.viewSlice(0).viewRow(particle).toArray(this.array);
        return this.array;
    }

    double getPosition(int particle, int dimension) {
        return this.swarm.getQuick(0, particle, dimension);
    }

    void setPosition(int particle, int dimension, double position) {
        this.swarm.setQuick(0, particle, dimension, position);
    }

    double[] getVelocity(int particle) {
        this.swarm.viewSlice(1).viewRow(particle).toArray(this.array);
        return this.array;
    }

    double getVelocity(int particle, int dimension) {
        return this.swarm.getQuick(1, particle, dimension);
    }

    void setVelocity(int particle, int dimension, double velocity) {
        this.swarm.setQuick(1, particle, dimension, velocity);
    }

    double[] getCognitiveMemory(int particle) {
        this.swarm.viewSlice(2).viewRow(particle).toArray(this.array);
        return this.array;
    }

    double getCognitiveMemory(int particle, int dimension) {
        return this.swarm.getQuick(2, particle, dimension);
    }

    @Override
    public double[] getSocialMemory() {
        this.socialMemory.toArray(this.array);
        return this.array;
    }

    double getSocialMemory(int dimension) {
        return this.socialMemory.getQuick(dimension);
    }

    double getFitness(int particle) {
        return this.fitness.getQuick(particle);
    }

    void setFitness(int particle, double fitness) {
        this.fitness.setQuick(particle, fitness);
    }

    void updateCognitiveMemory(int particle) {
        for (int dimension = 0; dimension < this.dimensions; ++dimension) {
            double value = this.swarm.getQuick(0, particle, dimension);
            this.swarm.setQuick(2, particle, dimension, value);
        }
    }

    void updateSocialMemory(int particle) {
        for (int dimension = 0; dimension < this.dimensions; ++dimension) {
            double value = this.swarm.getQuick(0, particle, dimension);
            this.socialMemory.setQuick(dimension, value);
        }
    }

    @Override
    public Iterator<Particle> iterator() {
        return new ParticleIterator();
    }

    private class ParticleImpl
    implements Particle {
        private final int index;

        ParticleImpl(int index) {
            this.index = index;
        }

        public int getDimensions() {
            return ParticleSwarmImpl.this.getDimensions();
        }

        public double getFitness() {
            return ParticleSwarmImpl.this.getFitness(this.index);
        }

        public double[] getPosition() {
            return ParticleSwarmImpl.this.getPosition(this.index);
        }

        public double[] getVelocity() {
            return ParticleSwarmImpl.this.getVelocity(this.index);
        }

        public double[] getCognitiveMemory() {
            return ParticleSwarmImpl.this.getCognitiveMemory(this.index);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ParticleIterator
    implements Iterator<Particle> {
        private int index = 0;

        private ParticleIterator() {
        }

        @Override
        public boolean hasNext() {
            return this.index < ParticleSwarmImpl.this.particles;
        }

        @Override
        public Particle next() {
            ParticleImpl particle = new ParticleImpl(this.index);
            ++this.index;
            return particle;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("remove operation not supported by this iterator");
        }
    }
}

