/*
 * Decompiled with CFR 0.152.
 */
package org.dishevelled.thumbnail;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.attribute.PosixFilePermission;
import java.util.EnumSet;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.imageio.ImageIO;
import org.apache.commons.codec.digest.DigestUtils;
import org.dishevelled.thumbnail.Thumbnail;
import org.dishevelled.thumbnail.ThumbnailManager;
import org.imgscalr.Scalr;

public abstract class AbstractThumbnailManager
implements ThumbnailManager {
    private final File directory;
    private final File normalDirectory;
    private final File largeDirectory;
    private final File failDirectory;
    private static final int MAXIMUM_SIZE = 1000;
    private static final int EXPIRE = 30;
    private final LoadingCache<File, Thumbnail> cache = CacheBuilder.newBuilder().maximumSize(1000L).expireAfterWrite(30L, TimeUnit.SECONDS).build((CacheLoader)new CacheLoader<File, Thumbnail>(){

        public Thumbnail load(File key) throws IOException {
            return Thumbnail.read(key);
        }
    });
    private static final int NORMAL_SIZE = 128;
    private static final int LARGE_SIZE = 256;
    private static final Set<PosixFilePermission> DIRECTORY_PERMISSIONS = EnumSet.of(PosixFilePermission.OWNER_READ, PosixFilePermission.OWNER_WRITE, PosixFilePermission.OWNER_EXECUTE);
    private static final Set<PosixFilePermission> FILE_PERMISSIONS = EnumSet.of(PosixFilePermission.OWNER_READ, PosixFilePermission.OWNER_WRITE);

    protected AbstractThumbnailManager(File directory) {
        if (directory == null) {
            throw new IllegalArgumentException("directory must not be null");
        }
        this.directory = directory;
        this.normalDirectory = new File(this.directory, "normal");
        this.largeDirectory = new File(this.directory, "large");
        this.failDirectory = new File(this.directory, "fail");
        this.normalDirectory.mkdirs();
        this.largeDirectory.mkdirs();
        this.failDirectory.mkdirs();
        this.fixDirectoryPermissions(this.directory);
        this.fixDirectoryPermissions(this.normalDirectory);
        this.fixDirectoryPermissions(this.largeDirectory);
        this.fixDirectoryPermissions(this.failDirectory);
    }

    private void fixPermissions(File file) {
        try {
            Files.setPosixFilePermissions(file.toPath(), FILE_PERMISSIONS);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void fixDirectoryPermissions(File directory) {
        try {
            Files.setPosixFilePermissions(directory.toPath(), DIRECTORY_PERMISSIONS);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void createFailFile(File failFile) {
        try {
            failFile.createNewFile();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private BufferedImage createThumbnail(URI uri, long modificationTime, File thumbnailDirectory, int size) throws IOException {
        Thumbnail thumbnail;
        if (uri == null) {
            throw new IllegalArgumentException("uri must not be null");
        }
        String fileName = DigestUtils.md5Hex((String)uri.toString()) + ".png";
        File failFile = new File(this.failDirectory, fileName);
        if (failFile.exists()) {
            throw new IOException("cannot create a thumbnail image for " + uri);
        }
        File thumbnailFile = new File(thumbnailDirectory, fileName);
        if (thumbnailFile.exists() && (thumbnail = (Thumbnail)this.cache.getUnchecked((Object)thumbnailFile)).getModificationTime() == modificationTime) {
            return thumbnail.getImage();
        }
        URL url = uri.toURL();
        BufferedImage image = null;
        try {
            image = ImageIO.read(url);
        }
        catch (IOException e) {
            this.createFailFile(failFile);
            throw new IOException("cannot create a thumbnail image for " + uri, e);
        }
        if (image == null) {
            this.createFailFile(failFile);
            throw new IOException("cannot create a thumbnail image for " + uri);
        }
        Thumbnail thumbnail2 = new Thumbnail(uri, modificationTime, image.getWidth(), image.getHeight(), Scalr.resize((BufferedImage)image, (int)size, (BufferedImageOp[])new BufferedImageOp[0]));
        File tmp = File.createTempFile("tmp", ".png", thumbnailDirectory);
        this.fixPermissions(tmp);
        thumbnail2.write(tmp);
        com.google.common.io.Files.move((File)tmp, (File)thumbnailFile);
        return thumbnail2.getImage();
    }

    @Override
    public final BufferedImage createThumbnail(URI uri, long modificationTime) throws IOException {
        return this.createThumbnail(uri, modificationTime, this.normalDirectory, 128);
    }

    @Override
    public final BufferedImage createLargeThumbnail(URI uri, long modificationTime) throws IOException {
        return this.createThumbnail(uri, modificationTime, this.largeDirectory, 256);
    }
}

