/*
 * Decompiled with CFR 0.152.
 */
package org.dishevelled.thumbnail;

import com.sun.imageio.plugins.png.PNGMetadata;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.metadata.IIOMetadataNode;
import javax.imageio.stream.ImageOutputStream;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

final class Thumbnail {
    private final URI uri;
    private final long modificationTime;
    private final int width;
    private final int height;
    private final BufferedImage image;

    Thumbnail(URI uri, long modificationTime, int width, int height, BufferedImage image) {
        this.uri = uri;
        this.modificationTime = modificationTime;
        this.width = width;
        this.height = height;
        this.image = image;
    }

    URI getURI() {
        return this.uri;
    }

    long getModificationTime() {
        return this.modificationTime;
    }

    int getWidth() {
        return this.width;
    }

    int getHeight() {
        return this.height;
    }

    BufferedImage getImage() {
        return this.image;
    }

    static Thumbnail read(File file) throws IOException {
        if (file == null) {
            throw new IllegalArgumentException("file must not be null");
        }
        if (!file.canRead()) {
            throw new IllegalArgumentException("file must be readable");
        }
        FileInputStream inputStream = null;
        try {
            inputStream = new FileInputStream(file);
            ImageReader imageReader = ImageIO.getImageReadersByFormatName("png").next();
            imageReader.setInput(ImageIO.createImageInputStream(inputStream), true);
            IIOMetadata metadata = imageReader.getImageMetadata(0);
            PNGMetadata pngMetadata = (PNGMetadata)metadata;
            NodeList childNodes = pngMetadata.getStandardTextNode().getChildNodes();
            URI uri = null;
            long modificationTime = 0L;
            int width = 0;
            int height = 0;
            BufferedImage image = null;
            for (int i = 0; i < childNodes.getLength(); ++i) {
                Node node = childNodes.item(i);
                String keyword = node.getAttributes().getNamedItem("keyword").getNodeValue();
                String value = node.getAttributes().getNamedItem("value").getNodeValue();
                if ("Thumb::URI".equals(keyword)) {
                    try {
                        uri = new URI(value);
                    }
                    catch (URISyntaxException uRISyntaxException) {}
                    continue;
                }
                if ("Thumb::MTime".equals(keyword)) {
                    modificationTime = Long.parseLong(value);
                    continue;
                }
                if ("Thumb::Image::Width".equals(keyword)) {
                    width = Integer.parseInt(value);
                    continue;
                }
                if (!"Thumb::Image::Height".equals(keyword)) continue;
                height = Integer.parseInt(value);
            }
            image = imageReader.read(0);
            Thumbnail thumbnail = new Thumbnail(uri, modificationTime, width, height, image);
            return thumbnail;
        }
        catch (IOException e) {
            throw e;
        }
        finally {
            try {
                inputStream.close();
            }
            catch (Exception exception) {}
        }
    }

    private IIOMetadataNode createMetadataNode(String keyword, String value) {
        IIOMetadataNode textEntry = new IIOMetadataNode("tEXtEntry");
        textEntry.setAttribute("keyword", keyword);
        textEntry.setAttribute("value", value);
        IIOMetadataNode text = new IIOMetadataNode("tEXt");
        text.appendChild(textEntry);
        return text;
    }

    void write(File file) throws IOException {
        if (file == null) {
            throw new IllegalArgumentException("file must not be null");
        }
        if (!file.canWrite()) {
            throw new IllegalArgumentException("file must be writeable");
        }
        ImageWriter writer = ImageIO.getImageWritersByFormatName("png").next();
        ImageWriteParam writeParam = writer.getDefaultWriteParam();
        ImageTypeSpecifier typeSpecifier = ImageTypeSpecifier.createFromBufferedImageType(2);
        IIOMetadata metadata = writer.getDefaultImageMetadata(typeSpecifier, writeParam);
        IIOMetadataNode root = new IIOMetadataNode("javax_imageio_png_1.0");
        root.appendChild(this.createMetadataNode("Thumb::URI", this.uri.toString()));
        root.appendChild(this.createMetadataNode("Thumb::MTime", String.valueOf(this.modificationTime)));
        if (this.width > 0) {
            root.appendChild(this.createMetadataNode("Thumb::Image::Width", String.valueOf(this.width)));
        }
        if (this.height > 0) {
            root.appendChild(this.createMetadataNode("Thumb::Image::Height", String.valueOf(this.height)));
        }
        metadata.mergeTree("javax_imageio_png_1.0", root);
        FileOutputStream fileOutputStream = null;
        ImageOutputStream imageOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(file);
            imageOutputStream = ImageIO.createImageOutputStream(fileOutputStream);
            writer.setOutput(imageOutputStream);
            writer.write(metadata, new IIOImage(this.image, null, metadata), writeParam);
        }
        catch (IOException e) {
            throw e;
        }
        finally {
            try {
                fileOutputStream.close();
            }
            catch (Exception exception) {}
            try {
                imageOutputStream.close();
            }
            catch (Exception exception) {}
        }
    }
}

