/*
 * Decompiled with CFR 0.152.
 */
package org.dishevelled.thumbnail;

import java.io.File;
import org.dishevelled.thumbnail.AbstractThumbnailManager;

public final class XdgThumbnailManager
extends AbstractThumbnailManager {
    private static final File THUMBNAIL_DIRECTORY;

    public XdgThumbnailManager() {
        super(THUMBNAIL_DIRECTORY);
    }

    static {
        File thumbnailDirectory = null;
        String xdgCacheHome = System.getenv("XDG_CACHE_HOME");
        if (xdgCacheHome != null) {
            thumbnailDirectory = new File(xdgCacheHome, "thumbnails");
        } else {
            String userHome = System.getProperty("user.home");
            File cache = new File(userHome, ".cache");
            cache.mkdir();
            cache.setReadable(true, true);
            cache.setWritable(true, true);
            cache.setExecutable(true, true);
            thumbnailDirectory = new File(cache, "thumbnails");
        }
        THUMBNAIL_DIRECTORY = thumbnailDirectory;
    }
}

