/*
 * Decompiled with CFR 0.152.
 */
package org.dishevelled.thumbnail.swing;

import java.awt.Component;
import java.awt.image.BufferedImage;
import java.net.URI;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JList;
import org.dishevelled.identify.StripeListCellRenderer;
import org.dishevelled.thumbnail.swing.ThumbnailCache;

public final class LargeThumbnailListCellRenderer
extends StripeListCellRenderer {
    private final ThumbnailCache thumbnailCache;
    private transient ImageIcon imageIcon;

    public LargeThumbnailListCellRenderer(ThumbnailCache thumbnailCache) {
        if (thumbnailCache == null) {
            throw new IllegalArgumentException("thumbnailCache must not be null");
        }
        this.thumbnailCache = thumbnailCache;
    }

    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean hasFocus) {
        JLabel label = (JLabel)super.getListCellRendererComponent(list, value, index, isSelected, hasFocus);
        if (value instanceof URI) {
            URI uri = (URI)value;
            BufferedImage thumbnail = this.thumbnailCache.getLargeThumbnail(uri);
            if (this.imageIcon == null) {
                this.imageIcon = new ImageIcon(thumbnail);
            } else {
                this.imageIcon.setImage(thumbnail);
            }
            label.setIcon(this.imageIcon);
        }
        return label;
    }
}

