/*
 * Decompiled with CFR 0.152.
 */
package org.dishevelled.thumbnail.swing;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.net.URI;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;

final class LastModifiedCache {
    private final ExecutorService executorService;
    private final WatchService watcher;
    private final ConcurrentMap<WatchKey, Path> watchKeys = Maps.newConcurrentMap();
    private static final int MAXIMUM_SIZE = 100000;
    private final LoadingCache<Path, Long> cache = CacheBuilder.newBuilder().maximumSize(100000L).build((CacheLoader)new CacheLoader<Path, Long>(){

        public Long load(Path path) throws IOException {
            Path parent = path.getParent();
            if (parent != null) {
                LastModifiedCache.this.watchKeys.putIfAbsent(parent.register(LastModifiedCache.this.watcher, StandardWatchEventKinds.ENTRY_DELETE, StandardWatchEventKinds.ENTRY_MODIFY), parent);
            }
            return path.toFile().lastModified();
        }
    });

    LastModifiedCache(ExecutorService executorService) {
        if (executorService == null) {
            throw new IllegalArgumentException("executorService must not be null");
        }
        this.executorService = executorService;
        try {
            this.watcher = FileSystems.getDefault().newWatchService();
        }
        catch (Exception e) {
            throw new RuntimeException("could not create last modified cache", e);
        }
        executorService.submit(new Runnable(){

            @Override
            public void run() {
                LastModifiedCache.this.processEvents();
            }
        });
    }

    void processEvents() {
        while (true) {
            WatchKey key = null;
            try {
                key = this.watcher.take();
            }
            catch (InterruptedException e) {
                return;
            }
            Path dir = (Path)this.watchKeys.get(key);
            for (WatchEvent<?> event : key.pollEvents()) {
                WatchEvent.Kind<?> kind = event.kind();
                if (kind == StandardWatchEventKinds.OVERFLOW) continue;
                WatchEvent pathEvent = LastModifiedCache.cast(event);
                Path name = (Path)pathEvent.context();
                Path path = dir.resolve(name);
                if (kind == StandardWatchEventKinds.ENTRY_DELETE) {
                    this.deleted(path);
                    continue;
                }
                if (kind != StandardWatchEventKinds.ENTRY_MODIFY) continue;
                this.modified(path);
            }
            if (key.reset()) continue;
            this.watchKeys.remove(key);
        }
    }

    void deleted(Path path) {
        this.cache.invalidate((Object)path);
    }

    void modified(Path path) {
        this.cache.invalidate((Object)path);
    }

    long get(URI uri) {
        return this.get(Paths.get(uri));
    }

    long get(Path path) {
        return (Long)this.cache.getUnchecked((Object)path);
    }

    private static <T> WatchEvent<T> cast(WatchEvent<?> event) {
        return event;
    }
}

