/*
 * Decompiled with CFR 0.152.
 */
package org.dishevelled.thumbnail.swing;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListenableFutureTask;
import java.awt.Component;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.net.URI;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import javax.swing.SwingUtilities;
import org.dishevelled.thumbnail.ThumbnailManager;
import org.dishevelled.thumbnail.swing.LastModifiedCache;

public final class ThumbnailCache {
    private static final BufferedImage EMPTY_IMAGE = new BufferedImage(128, 128, 2);
    private static final BufferedImage EMPTY_LARGE_IMAGE = new BufferedImage(256, 256, 2);
    private final ThumbnailManager thumbnailManager;
    private final List<Component> repaint;
    private final ExecutorService executorService;
    private final LastModifiedCache lastModifiedCache;
    private static final int MAXIMUM_SIZE = 100000;
    private static final int REFRESH = 10;
    private final LoadingCache<URI, BufferedImage> cache = CacheBuilder.newBuilder().maximumSize(100000L).refreshAfterWrite(10L, TimeUnit.MILLISECONDS).build((CacheLoader)new CacheLoader<URI, BufferedImage>(){

        public BufferedImage load(URI uri) {
            return EMPTY_IMAGE;
        }

        public ListenableFuture<BufferedImage> reload(final URI uri, BufferedImage image) {
            if (image.equals(EMPTY_IMAGE)) {
                ListenableFutureTask task = ListenableFutureTask.create((Callable)new Callable<BufferedImage>(){

                    @Override
                    public BufferedImage call() throws IOException {
                        return ThumbnailCache.this.thumbnailManager.createThumbnail(uri, ThumbnailCache.this.lastModifiedCache.get(uri));
                    }
                });
                task.addListener(new Runnable(){

                    @Override
                    public void run() {
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                for (Component component : ThumbnailCache.this.repaint) {
                                    component.repaint();
                                }
                            }
                        });
                    }
                }, (Executor)ThumbnailCache.this.executorService);
                ThumbnailCache.this.executorService.execute((Runnable)task);
                return task;
            }
            return Futures.immediateFuture((Object)image);
        }
    });
    private final LoadingCache<URI, BufferedImage> largeCache = CacheBuilder.newBuilder().maximumSize(100000L).refreshAfterWrite(10L, TimeUnit.MILLISECONDS).build((CacheLoader)new CacheLoader<URI, BufferedImage>(){

        public BufferedImage load(URI uri) {
            return EMPTY_IMAGE;
        }

        public ListenableFuture<BufferedImage> reload(final URI uri, BufferedImage image) {
            if (image.equals(EMPTY_IMAGE)) {
                ListenableFutureTask task = ListenableFutureTask.create((Callable)new Callable<BufferedImage>(){

                    @Override
                    public BufferedImage call() throws IOException {
                        return ThumbnailCache.this.thumbnailManager.createLargeThumbnail(uri, ThumbnailCache.this.lastModifiedCache.get(uri));
                    }
                });
                ThumbnailCache.this.executorService.execute((Runnable)task);
                return task;
            }
            return Futures.immediateFuture((Object)image);
        }
    });

    public ThumbnailCache(ThumbnailManager thumbnailManager) {
        if (thumbnailManager == null) {
            throw new IllegalArgumentException("thumbnailManager must not be null");
        }
        this.thumbnailManager = thumbnailManager;
        this.repaint = new CopyOnWriteArrayList<Component>();
        this.executorService = Executors.newCachedThreadPool();
        this.lastModifiedCache = new LastModifiedCache(this.executorService);
    }

    public void add(Component component) {
        if (component == null) {
            throw new IllegalArgumentException("component must not be null");
        }
        this.repaint.add(component);
    }

    public void remove(Component component) {
        this.repaint.remove(component);
    }

    public BufferedImage getThumbnail(URI uri) {
        return (BufferedImage)this.cache.getUnchecked((Object)uri);
    }

    public BufferedImage getLargeThumbnail(URI uri) {
        return (BufferedImage)this.largeCache.getUnchecked((Object)uri);
    }
}

