/*
 * Decompiled with CFR 0.152.
 */
package org.dishevelled.thumbnail.swing;

import java.awt.Component;
import java.awt.image.BufferedImage;
import java.net.URI;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.Renderer;
import org.dishevelled.thumbnail.swing.ThumbnailCache;

public final class ThumbnailRenderer
implements Renderer {
    private final ThumbnailCache thumbnailCache;
    private final JLabel delegate = new JLabel();
    private transient ImageIcon imageIcon;

    public ThumbnailRenderer(ThumbnailCache thumbnailCache) {
        if (thumbnailCache == null) {
            throw new IllegalArgumentException("thumbnailCache must not be null");
        }
        this.thumbnailCache = thumbnailCache;
    }

    @Override
    public Component getComponent() {
        return this.delegate;
    }

    @Override
    public void setValue(Object value, boolean selected) {
        if (value instanceof URI) {
            URI uri = (URI)value;
            BufferedImage thumbnail = this.thumbnailCache.getThumbnail(uri);
            if (this.imageIcon == null) {
                this.imageIcon = new ImageIcon(thumbnail);
            } else {
                this.imageIcon.setImage(thumbnail);
            }
            this.delegate.setIcon(this.imageIcon);
        }
    }
}

