/*
 * Decompiled with CFR 0.152.
 */
package org.dishevelled.thumbnail.swing;

import java.awt.Component;
import java.awt.image.BufferedImage;
import java.net.URI;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JTable;
import org.dishevelled.identify.StripeTableCellRenderer;
import org.dishevelled.thumbnail.swing.ThumbnailCache;

public final class ThumbnailTableCellRenderer
extends StripeTableCellRenderer {
    private final ThumbnailCache thumbnailCache;
    private transient ImageIcon imageIcon;

    public ThumbnailTableCellRenderer(ThumbnailCache thumbnailCache) {
        if (thumbnailCache == null) {
            throw new IllegalArgumentException("thumbnailCache must not be null");
        }
        this.thumbnailCache = thumbnailCache;
    }

    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        JLabel label = (JLabel)super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        if (value instanceof URI) {
            URI uri = (URI)value;
            BufferedImage thumbnail = this.thumbnailCache.getThumbnail(uri);
            if (this.imageIcon == null) {
                this.imageIcon = new ImageIcon(thumbnail);
            } else {
                this.imageIcon.setImage(thumbnail);
            }
            label.setIcon(this.imageIcon);
        }
        return label;
    }
}

