/*
 * Decompiled with CFR 0.152.
 */
package org.dishevelled.venn.tools;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.dishevelled.commandline.Argument;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class AbstractVennRunnable
implements Runnable {
    private final boolean count;
    private final boolean header;
    protected static final File STDOUT = new File(".");

    protected AbstractVennRunnable(boolean count, boolean header) {
        this.count = count;
        this.header = header;
    }

    protected final boolean count() {
        return this.count;
    }

    protected final boolean header() {
        return this.header;
    }

    protected static final void write(boolean write, String labelText, PrintWriter stdout) {
        if (write) {
            stdout.print(labelText);
            stdout.print("\t");
        }
    }

    protected static final void write(boolean write, int size, PrintWriter stdout) {
        if (write) {
            stdout.print(size);
            stdout.print("\t");
        }
    }

    protected static final void write(boolean write, Iterator<String> it, PrintWriter stdout) {
        if (write) {
            if (it.hasNext()) {
                stdout.print(it.next());
            }
            stdout.print("\t");
        }
    }

    protected static final Set<String> read(File input) {
        BufferedReader reader = null;
        HashSet<String> result = new HashSet<String>(Math.max(16, (int)input.length() / 64));
        try {
            reader = new BufferedReader(new FileReader(input));
            while (reader.ready()) {
                result.add(reader.readLine().trim());
            }
        }
        catch (IOException e) {
            throw new IllegalArgumentException("could not read input file " + input + ", " + e.getMessage());
        }
        finally {
            try {
                reader.close();
            }
            catch (Exception exception) {}
        }
        return result;
    }

    protected void write(String headerText, Set<String> view, File file) {
        if (file == null || STDOUT.equals(file)) {
            return;
        }
        PrintWriter writer = null;
        try {
            writer = new PrintWriter(new BufferedWriter(new FileWriter(file)));
            if (this.header) {
                writer.println(headerText);
            }
            if (this.count) {
                writer.println(view.size());
            } else {
                for (String s : view) {
                    writer.println(s);
                }
            }
        }
        catch (IOException e) {
            throw new IllegalArgumentException("could not write to output file " + file + ", " + e.getMessage());
        }
        finally {
            try {
                writer.close();
            }
            catch (Exception exception) {}
        }
    }

    protected static final <T> T defaultIfFound(Argument<T> argument, T value0, T value1, T defaultValue) {
        if (argument.wasFound()) {
            if (argument.getValue() == null) {
                return defaultValue;
            }
            if (value0.equals(argument.getValue()) || value1.equals(argument.getValue())) {
                return defaultValue;
            }
            return (T)argument.getValue();
        }
        return null;
    }

    protected static final <T> T defaultIfFound(Argument<T> argument, T value0, T value1, T value2, T defaultValue) {
        if (argument.wasFound()) {
            if (argument.getValue() == null) {
                return defaultValue;
            }
            if (value0.equals(argument.getValue()) || value1.equals(argument.getValue()) || value2.equals(argument.getValue())) {
                return defaultValue;
            }
            return (T)argument.getValue();
        }
        return null;
    }

    protected static final <T> T defaultIfFound(Argument<T> argument, T value0, T value1, T value2, T value3, T defaultValue) {
        if (argument.wasFound()) {
            if (argument.getValue() == null) {
                return defaultValue;
            }
            if (value0.equals(argument.getValue()) || value1.equals(argument.getValue()) || value2.equals(argument.getValue()) || value3.equals(argument.getValue())) {
                return defaultValue;
            }
            return (T)argument.getValue();
        }
        return null;
    }
}

