/*
 * Decompiled with CFR 0.152.
 */
package org.dishevelled.venn.tools;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.io.BufferedWriter;
import java.io.File;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.dishevelled.bitset.ImmutableBitSet;
import org.dishevelled.bitset.MutableBitSet;
import org.dishevelled.commandline.Argument;
import org.dishevelled.commandline.ArgumentList;
import org.dishevelled.commandline.CommandLine;
import org.dishevelled.commandline.CommandLineParseException;
import org.dishevelled.commandline.CommandLineParser;
import org.dishevelled.commandline.Switch;
import org.dishevelled.commandline.Usage;
import org.dishevelled.venn.VennModel;
import org.dishevelled.venn.model.VennModels;
import org.dishevelled.venn.tools.AbstractVennRunnable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Venn
extends AbstractVennRunnable {
    private final List<File> inputFiles;
    private static final String USAGE = "java Venn [args] [input-files]";

    private Venn(boolean count, boolean header, List<File> inputFiles) {
        super(count, header);
        if (inputFiles == null) {
            throw new IllegalArgumentException("inputFiles must not be null");
        }
        if (inputFiles.size() < 2) {
            throw new IllegalArgumentException("inputFiles must contain at least two input files");
        }
        if (inputFiles.size() > 29) {
            throw new IllegalArgumentException("inputFiles must contain less than 30 input files");
        }
        this.inputFiles = inputFiles;
    }

    @Override
    public void run() {
        int n = this.inputFiles.size();
        ArrayList<String> labels = new ArrayList<String>(n);
        ArrayList<Set<String>> sets = new ArrayList<Set<String>>(n);
        for (File inputFile : this.inputFiles) {
            labels.add(inputFile.getName());
            sets.add(Venn.read(inputFile));
        }
        VennModel model = VennModels.createVennModel(sets);
        ImmutableMap.Builder builder = ImmutableMap.builder();
        Set powerSet = Sets.powerSet(Venn.range(n));
        for (Set set : powerSet) {
            if (set.isEmpty()) continue;
            ImmutableBitSet key = Venn.toImmutableBitSet(set);
            builder.put((Object)key, (Object)model.exclusiveTo(Venn.first(key), Venn.additional(key)));
        }
        ImmutableMap views = builder.build();
        PrintWriter writer = new PrintWriter(new BufferedWriter(new OutputStreamWriter(System.out)));
        if (this.header()) {
            for (Map.Entry entry : views.entrySet()) {
                Venn.write(true, Venn.buildLabel(labels, (ImmutableBitSet)entry.getKey()), writer);
            }
            writer.print("\n");
        }
        if (this.count()) {
            for (Map.Entry entry : views.entrySet()) {
                Venn.write(true, ((Set)entry.getValue()).size(), writer);
            }
            writer.print("\n");
        } else {
            boolean bl;
            ArrayList iterators = new ArrayList();
            for (Map.Entry entry : views.entrySet()) {
                iterators.add(((Set)entry.getValue()).iterator());
            }
            boolean bl2 = false;
            while (!bl) {
                boolean bl3;
                boolean bl4 = false;
                for (Iterator iterator : iterators) {
                    if (iterator.hasNext()) {
                        writer.write((String)iterator.next());
                        bl3 = true;
                    }
                    writer.write("\t");
                }
                writer.print("\n");
                bl = !bl3;
            }
        }
        try {
            writer.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    static String buildLabel(List<String> labels, ImmutableBitSet key) {
        int first = Venn.first(key);
        int[] additional = Venn.additional(key);
        StringBuilder sb = new StringBuilder();
        sb.append(labels.get(first));
        if (additional.length > 0) {
            int size = additional.length - 1;
            for (int i = 0; i < size; ++i) {
                sb.append(", ");
                sb.append(labels.get(additional[i]));
            }
            sb.append(" and ");
            sb.append(labels.get(additional[Math.max(0, additional.length - 1)]));
        }
        sb.append(" only");
        return sb.toString();
    }

    static ImmutableSet<Integer> range(int n) {
        HashSet range = Sets.newHashSet();
        for (int i = 0; i < n; ++i) {
            range.add(i);
        }
        return ImmutableSet.copyOf((Collection)range);
    }

    static int first(ImmutableBitSet bitSet) {
        return (int)bitSet.nextSetBit(0L);
    }

    static int[] additional(ImmutableBitSet bitSet) {
        int[] additional = new int[Math.max(0, (int)bitSet.cardinality() - 1)];
        int index = 0;
        long first = bitSet.nextSetBit(0L);
        long value = bitSet.nextSetBit(first + 1L);
        while (value >= 0L) {
            additional[index] = (int)value;
            ++index;
            value = bitSet.nextSetBit(value + 1L);
        }
        return additional;
    }

    static int first(Set<Integer> values) {
        if (values.isEmpty()) {
            return -1;
        }
        return values.iterator().next();
    }

    static int[] additional(Set<Integer> values) {
        int[] additional = new int[Math.max(0, values.size() - 1)];
        int index = -1;
        for (Integer value : values) {
            if (index >= 0) {
                additional[index] = value;
            }
            ++index;
        }
        return additional;
    }

    static ImmutableBitSet toImmutableBitSet(Set<Integer> indices) {
        if (indices == null) {
            throw new IllegalArgumentException("indices must not be null");
        }
        if (indices.isEmpty()) {
            throw new IllegalArgumentException("indices must not be empty");
        }
        MutableBitSet mutableBitSet = new MutableBitSet((long)indices.size());
        for (Integer index : indices) {
            mutableBitSet.set((long)index.intValue());
        }
        mutableBitSet.trimTrailingZeros();
        return mutableBitSet.immutableCopy();
    }

    public static void main(String[] args) {
        CommandLine commandLine = null;
        ArgumentList arguments = null;
        try {
            Switch help = new Switch("h", "help", "display help message");
            Switch count = new Switch("c", "count", "output count(s) only");
            Switch header = new Switch("e", "header", "output header(s)");
            arguments = new ArgumentList(new Argument[]{help, count, header});
            commandLine = new CommandLine(args);
            CommandLineParser.parse((CommandLine)commandLine, (ArgumentList)arguments);
            if (help.wasFound()) {
                Usage.usage((String)USAGE, null, (CommandLine)commandLine, (ArgumentList)arguments, (OutputStream)System.out);
            } else {
                ArrayList<File> inputFiles = new ArrayList<File>(args.length);
                for (int i = 0; i < args.length; ++i) {
                    if (args[i].startsWith("-")) continue;
                    inputFiles.add(new File(args[i]));
                }
                new Venn(count.wasFound(), header.wasFound(), inputFiles).run();
            }
        }
        catch (CommandLineParseException e) {
            Usage.usage((String)USAGE, (Throwable)e, commandLine, arguments, (OutputStream)System.err);
        }
        catch (IllegalArgumentException e) {
            Usage.usage((String)USAGE, (Throwable)e, commandLine, arguments, (OutputStream)System.err);
        }
    }
}

