/*
 * Decompiled with CFR 0.152.
 */
package org.dishevelled.venn.tools;

import java.io.BufferedWriter;
import java.io.File;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.Iterator;
import org.dishevelled.commandline.Argument;
import org.dishevelled.commandline.ArgumentList;
import org.dishevelled.commandline.CommandLine;
import org.dishevelled.commandline.CommandLineParseException;
import org.dishevelled.commandline.CommandLineParser;
import org.dishevelled.commandline.Switch;
import org.dishevelled.commandline.Usage;
import org.dishevelled.commandline.argument.FileArgument;
import org.dishevelled.venn.BinaryVennModel;
import org.dishevelled.venn.swing.BinaryVennLabel;
import org.dishevelled.venn.tools.AbstractVennRunnable;

public final class Venn2
extends AbstractVennRunnable {
    private final File first;
    private final File second;
    private final File firstOnly;
    private final File secondOnly;
    private final File intersection;
    private final File union;
    private static final String USAGE = "java Venn2 [args] first second";

    private Venn2(boolean count, boolean header, File first, File second, File firstOnly, File secondOnly, File intersection, File union) {
        super(count, header);
        this.first = first;
        this.second = second;
        if (firstOnly == null && secondOnly == null && intersection == null && union == null) {
            this.firstOnly = STDOUT;
            this.secondOnly = STDOUT;
            this.intersection = STDOUT;
            this.union = STDOUT;
        } else {
            this.firstOnly = firstOnly;
            this.secondOnly = secondOnly;
            this.intersection = intersection;
            this.union = union;
        }
    }

    public void run() {
        BinaryVennLabel label = new BinaryVennLabel(this.first.getName(), Venn2.read(this.first), this.second.getName(), Venn2.read(this.second));
        BinaryVennModel model = label.getModel();
        this.write(label.getFirstOnlyLabelText(), model.firstOnly(), this.firstOnly);
        this.write(label.getSecondOnlyLabelText(), model.secondOnly(), this.secondOnly);
        this.write(label.getIntersectionLabelText(), model.intersection(), this.intersection);
        this.write(label.getUnionLabelText(), model.union(), this.union);
        boolean fo = STDOUT.equals(this.firstOnly);
        boolean so = STDOUT.equals(this.secondOnly);
        boolean i = STDOUT.equals(this.intersection);
        boolean u = STDOUT.equals(this.union);
        PrintWriter stdout = null;
        stdout = new PrintWriter(new BufferedWriter(new OutputStreamWriter(System.out)));
        if (this.header()) {
            Venn2.write(fo, label.getFirstOnlyLabelText(), stdout);
            Venn2.write(so, label.getSecondOnlyLabelText(), stdout);
            Venn2.write(i, label.getIntersectionLabelText(), stdout);
            Venn2.write(u, label.getUnionLabelText(), stdout);
            stdout.print("\n");
        }
        if (this.count()) {
            Venn2.write(fo, model.firstOnly().size(), stdout);
            Venn2.write(so, model.secondOnly().size(), stdout);
            Venn2.write(i, model.intersection().size(), stdout);
            Venn2.write(u, model.union().size(), stdout);
            stdout.print("\n");
        } else {
            boolean remaining = fo || so || i || u;
            Iterator<String> foit = model.firstOnly().iterator();
            Iterator<String> soit = model.secondOnly().iterator();
            Iterator<String> iit = model.intersection().iterator();
            Iterator<String> uit = model.union().iterator();
            while (remaining) {
                Venn2.write(fo, foit, stdout);
                Venn2.write(so, soit, stdout);
                Venn2.write(i, iit, stdout);
                Venn2.write(u, uit, stdout);
                remaining = fo && foit.hasNext() || so && soit.hasNext() || i && iit.hasNext() || u && uit.hasNext();
                stdout.print("\n");
            }
        }
        try {
            stdout.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void main(String[] args) {
        CommandLine commandLine = null;
        ArgumentList arguments = null;
        try {
            Switch help = new Switch("h", "help", "display help message");
            Switch count = new Switch("c", "count", "output count(s) only");
            Switch header = new Switch("e", "header", "output header(s)");
            FileArgument firstOnly = new FileArgument("f", "first-only", "first only output file", false);
            FileArgument secondOnly = new FileArgument("s", "second-only", "second only output file", false);
            FileArgument intersection = new FileArgument("i", "intersection", "intersection output file", false);
            FileArgument union = new FileArgument("u", "union", "union output file", false);
            arguments = new ArgumentList(new Argument[]{help, count, header, firstOnly, secondOnly, intersection, union});
            commandLine = new CommandLine(args);
            CommandLineParser.parse((CommandLine)commandLine, (ArgumentList)arguments);
            if (help.wasFound()) {
                Usage.usage((String)USAGE, null, (CommandLine)commandLine, (ArgumentList)arguments, (OutputStream)System.out);
            } else {
                if (args.length < 2) {
                    throw new IllegalArgumentException("must have at least two file arguments, first and second input files");
                }
                File first = new File(args[args.length - 2]);
                File second = new File(args[args.length - 1]);
                if (first.getName().startsWith("-") || second.getName().startsWith("-")) {
                    throw new IllegalArgumentException("must have at least two file arguments, first and second input files");
                }
                File f = Venn2.defaultIfFound(firstOnly, first, second, STDOUT);
                File s = Venn2.defaultIfFound(secondOnly, first, second, STDOUT);
                File i = Venn2.defaultIfFound(intersection, first, second, STDOUT);
                File u = Venn2.defaultIfFound(union, first, second, STDOUT);
                new Venn2(count.wasFound(), header.wasFound(), first, second, f, s, i, u).run();
            }
        }
        catch (CommandLineParseException e) {
            Usage.usage((String)USAGE, (Throwable)e, commandLine, arguments, (OutputStream)System.err);
        }
        catch (IllegalArgumentException e) {
            Usage.usage((String)USAGE, (Throwable)e, commandLine, arguments, (OutputStream)System.err);
        }
    }
}

