/*
 * Decompiled with CFR 0.152.
 */
package org.dishevelled.venn.tools;

import java.io.BufferedWriter;
import java.io.File;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.Iterator;
import org.dishevelled.commandline.Argument;
import org.dishevelled.commandline.ArgumentList;
import org.dishevelled.commandline.CommandLine;
import org.dishevelled.commandline.CommandLineParseException;
import org.dishevelled.commandline.CommandLineParser;
import org.dishevelled.commandline.Switch;
import org.dishevelled.commandline.Usage;
import org.dishevelled.commandline.argument.FileArgument;
import org.dishevelled.venn.TernaryVennModel;
import org.dishevelled.venn.swing.TernaryVennLabel;
import org.dishevelled.venn.tools.AbstractVennRunnable;

public final class Venn3
extends AbstractVennRunnable {
    private final File first;
    private final File second;
    private final File third;
    private final File firstOnly;
    private final File secondOnly;
    private final File thirdOnly;
    private final File firstSecond;
    private final File secondThird;
    private final File intersection;
    private final File union;
    private static final String USAGE = "java Venn3 [args] first second third";

    private Venn3(boolean count, boolean header, File first, File second, File third, File firstOnly, File secondOnly, File thirdOnly, File firstSecond, File secondThird, File intersection, File union) {
        super(count, header);
        this.first = first;
        this.second = second;
        this.third = third;
        if (firstOnly == null && secondOnly == null && thirdOnly == null && firstSecond == null && secondThird == null && intersection == null && union == null) {
            this.firstOnly = STDOUT;
            this.secondOnly = STDOUT;
            this.thirdOnly = STDOUT;
            this.firstSecond = STDOUT;
            this.secondThird = STDOUT;
            this.intersection = STDOUT;
            this.union = STDOUT;
        } else {
            this.firstOnly = firstOnly;
            this.secondOnly = secondOnly;
            this.thirdOnly = thirdOnly;
            this.firstSecond = firstSecond;
            this.secondThird = secondThird;
            this.intersection = intersection;
            this.union = union;
        }
    }

    public void run() {
        TernaryVennLabel label = new TernaryVennLabel(this.first.getName(), Venn3.read(this.first), this.second.getName(), Venn3.read(this.second), this.third.getName(), Venn3.read(this.third));
        TernaryVennModel model = label.getModel();
        this.write(label.getFirstOnlyLabelText(), model.firstOnly(), this.firstOnly);
        this.write(label.getSecondOnlyLabelText(), model.secondOnly(), this.secondOnly);
        this.write(label.getThirdOnlyLabelText(), model.thirdOnly(), this.thirdOnly);
        this.write(label.getFirstSecondLabelText(), model.firstSecond(), this.firstSecond);
        this.write(label.getSecondThirdLabelText(), model.secondThird(), this.secondThird);
        this.write(label.getIntersectionLabelText(), model.intersection(), this.intersection);
        this.write(label.getUnionLabelText(), model.union(), this.union);
        boolean fo = STDOUT.equals(this.firstOnly);
        boolean so = STDOUT.equals(this.secondOnly);
        boolean to = STDOUT.equals(this.thirdOnly);
        boolean fs = STDOUT.equals(this.firstSecond);
        boolean st = STDOUT.equals(this.secondThird);
        boolean i = STDOUT.equals(this.intersection);
        boolean u = STDOUT.equals(this.union);
        PrintWriter stdout = null;
        stdout = new PrintWriter(new BufferedWriter(new OutputStreamWriter(System.out)));
        if (this.header()) {
            Venn3.write(fo, label.getFirstOnlyLabelText(), stdout);
            Venn3.write(so, label.getSecondOnlyLabelText(), stdout);
            Venn3.write(to, label.getThirdOnlyLabelText(), stdout);
            Venn3.write(fs, label.getFirstSecondLabelText(), stdout);
            Venn3.write(st, label.getSecondThirdLabelText(), stdout);
            Venn3.write(i, label.getIntersectionLabelText(), stdout);
            Venn3.write(u, label.getUnionLabelText(), stdout);
            stdout.print("\n");
        }
        if (this.count()) {
            Venn3.write(fo, model.firstOnly().size(), stdout);
            Venn3.write(so, model.secondOnly().size(), stdout);
            Venn3.write(to, model.thirdOnly().size(), stdout);
            Venn3.write(fs, model.firstSecond().size(), stdout);
            Venn3.write(st, model.secondThird().size(), stdout);
            Venn3.write(i, model.intersection().size(), stdout);
            Venn3.write(u, model.union().size(), stdout);
            stdout.print("\n");
        } else {
            boolean remaining = fo || so || to || fs || st || i || u;
            Iterator<String> foit = model.firstOnly().iterator();
            Iterator<String> soit = model.secondOnly().iterator();
            Iterator<String> toit = model.thirdOnly().iterator();
            Iterator<String> fsit = model.firstSecond().iterator();
            Iterator<String> stit = model.secondThird().iterator();
            Iterator<String> iit = model.intersection().iterator();
            Iterator<String> uit = model.union().iterator();
            while (remaining) {
                Venn3.write(fo, foit, stdout);
                Venn3.write(so, soit, stdout);
                Venn3.write(to, toit, stdout);
                Venn3.write(fs, fsit, stdout);
                Venn3.write(st, stit, stdout);
                Venn3.write(i, iit, stdout);
                Venn3.write(u, uit, stdout);
                remaining = fo && foit.hasNext() || so && soit.hasNext() || to && toit.hasNext() || fs && fsit.hasNext() || st && stit.hasNext() || i && iit.hasNext() || u && uit.hasNext();
                stdout.print("\n");
            }
        }
        try {
            stdout.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void main(String[] args) {
        CommandLine commandLine = null;
        ArgumentList arguments = null;
        try {
            Switch help = new Switch("h", "help", "display help message");
            Switch count = new Switch("c", "count", "output count(s) only");
            Switch header = new Switch("e", "header", "output header(s)");
            FileArgument firstOnly = new FileArgument("f", "first-only", "first only output file", false);
            FileArgument secondOnly = new FileArgument("s", "second-only", "second only output file", false);
            FileArgument thirdOnly = new FileArgument("t", "third-only", "third only output file", false);
            FileArgument firstSecond = new FileArgument("j", "first-second", "first second output file", false);
            FileArgument secondThird = new FileArgument("k", "second-third", "second third output file", false);
            FileArgument intersection = new FileArgument("i", "intersection", "intersection output file", false);
            FileArgument union = new FileArgument("u", "union", "union output file", false);
            arguments = new ArgumentList(new Argument[]{help, count, header, firstOnly, secondOnly, thirdOnly, firstSecond, secondThird, intersection, union});
            commandLine = new CommandLine(args);
            CommandLineParser.parse((CommandLine)commandLine, (ArgumentList)arguments);
            if (help.wasFound()) {
                Usage.usage((String)USAGE, null, (CommandLine)commandLine, (ArgumentList)arguments, (OutputStream)System.out);
            } else {
                if (args.length < 3) {
                    throw new IllegalArgumentException("must have at least three file arguments, first, second, and third input files");
                }
                File first = new File(args[args.length - 3]);
                File second = new File(args[args.length - 2]);
                File third = new File(args[args.length - 1]);
                if (first.getName().startsWith("-") || second.getName().startsWith("-") || third.getName().startsWith("-")) {
                    throw new IllegalArgumentException("must have at least three file arguments, first, second, and third input files");
                }
                File f = Venn3.defaultIfFound(firstOnly, first, second, third, STDOUT);
                File s = Venn3.defaultIfFound(secondOnly, first, second, third, STDOUT);
                File t = Venn3.defaultIfFound(thirdOnly, first, second, third, STDOUT);
                File j = Venn3.defaultIfFound(firstSecond, first, second, third, STDOUT);
                File k = Venn3.defaultIfFound(secondThird, first, second, third, STDOUT);
                File i = Venn3.defaultIfFound(intersection, first, second, third, STDOUT);
                File u = Venn3.defaultIfFound(union, first, second, third, STDOUT);
                new Venn3(count.wasFound(), header.wasFound(), first, second, third, f, s, t, j, k, i, u).run();
            }
        }
        catch (CommandLineParseException e) {
            Usage.usage((String)USAGE, (Throwable)e, commandLine, arguments, (OutputStream)System.err);
        }
        catch (IllegalArgumentException e) {
            Usage.usage((String)USAGE, (Throwable)e, commandLine, arguments, (OutputStream)System.err);
        }
    }
}

