/*
 * Decompiled with CFR 0.152.
 */
package org.dishevelled.venn.tools;

import java.io.BufferedWriter;
import java.io.File;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.Iterator;
import org.dishevelled.commandline.Argument;
import org.dishevelled.commandline.ArgumentList;
import org.dishevelled.commandline.CommandLine;
import org.dishevelled.commandline.CommandLineParseException;
import org.dishevelled.commandline.CommandLineParser;
import org.dishevelled.commandline.Switch;
import org.dishevelled.commandline.Usage;
import org.dishevelled.commandline.argument.FileArgument;
import org.dishevelled.venn.QuaternaryVennModel;
import org.dishevelled.venn.swing.QuaternaryVennLabel;
import org.dishevelled.venn.tools.AbstractVennRunnable;

public final class Venn4
extends AbstractVennRunnable {
    private final File first;
    private final File second;
    private final File third;
    private final File fourth;
    private final File firstOnly;
    private final File secondOnly;
    private final File thirdOnly;
    private final File fourthOnly;
    private final File firstSecond;
    private final File firstThird;
    private final File firstFourth;
    private final File secondThird;
    private final File secondFourth;
    private final File thirdFourth;
    private final File firstSecondThird;
    private final File firstSecondFourth;
    private final File firstThirdFourth;
    private final File secondThirdFourth;
    private final File intersection;
    private final File union;
    private static final String USAGE = "java Venn4 [args] first second third fourth";

    private Venn4(boolean count, boolean header, File first, File second, File third, File fourth, File firstOnly, File secondOnly, File thirdOnly, File fourthOnly, File firstSecond, File firstThird, File firstFourth, File secondThird, File secondFourth, File firstSecondThird, File firstSecondFourth, File firstThirdFourth, File secondThirdFourth, File thirdFourth, File intersection, File union) {
        super(count, header);
        this.first = first;
        this.second = second;
        this.third = third;
        this.fourth = fourth;
        if (firstOnly == null && secondOnly == null && thirdOnly == null && fourthOnly == null && firstSecond == null && firstThird == null && firstFourth == null && secondThird == null && secondFourth == null && thirdFourth == null && firstSecondThird == null && firstSecondFourth == null && firstThirdFourth == null && secondThirdFourth == null && intersection == null && union == null) {
            this.firstOnly = STDOUT;
            this.secondOnly = STDOUT;
            this.thirdOnly = STDOUT;
            this.fourthOnly = STDOUT;
            this.firstSecond = STDOUT;
            this.firstThird = STDOUT;
            this.firstFourth = STDOUT;
            this.secondThird = STDOUT;
            this.secondFourth = STDOUT;
            this.thirdFourth = STDOUT;
            this.firstSecondThird = STDOUT;
            this.firstSecondFourth = STDOUT;
            this.firstThirdFourth = STDOUT;
            this.secondThirdFourth = STDOUT;
            this.intersection = STDOUT;
            this.union = STDOUT;
        } else {
            this.firstOnly = firstOnly;
            this.secondOnly = secondOnly;
            this.thirdOnly = thirdOnly;
            this.fourthOnly = fourthOnly;
            this.firstSecond = firstSecond;
            this.firstThird = firstThird;
            this.firstFourth = firstFourth;
            this.secondThird = secondThird;
            this.secondFourth = secondFourth;
            this.thirdFourth = thirdFourth;
            this.firstSecondThird = firstSecondThird;
            this.firstSecondFourth = firstSecondFourth;
            this.firstThirdFourth = firstThirdFourth;
            this.secondThirdFourth = secondThirdFourth;
            this.intersection = intersection;
            this.union = union;
        }
    }

    public void run() {
        QuaternaryVennLabel label = new QuaternaryVennLabel(this.first.getName(), Venn4.read(this.first), this.second.getName(), Venn4.read(this.second), this.third.getName(), Venn4.read(this.third), this.fourth.getName(), Venn4.read(this.fourth));
        QuaternaryVennModel model = label.getModel();
        this.write(label.getFirstOnlyLabelText(), model.firstOnly(), this.firstOnly);
        this.write(label.getSecondOnlyLabelText(), model.secondOnly(), this.secondOnly);
        this.write(label.getThirdOnlyLabelText(), model.thirdOnly(), this.thirdOnly);
        this.write(label.getFourthOnlyLabelText(), model.fourthOnly(), this.fourthOnly);
        this.write(label.getFirstSecondLabelText(), model.firstSecond(), this.firstSecond);
        this.write(label.getFirstThirdLabelText(), model.firstThird(), this.firstThird);
        this.write(label.getFirstFourthLabelText(), model.firstFourth(), this.firstFourth);
        this.write(label.getSecondThirdLabelText(), model.secondThird(), this.secondThird);
        this.write(label.getSecondFourthLabelText(), model.secondFourth(), this.secondFourth);
        this.write(label.getThirdFourthLabelText(), model.thirdFourth(), this.thirdFourth);
        this.write(label.getFirstSecondThirdLabelText(), model.firstSecondThird(), this.firstSecondThird);
        this.write(label.getFirstSecondFourthLabelText(), model.firstSecondFourth(), this.firstSecondFourth);
        this.write(label.getFirstThirdFourthLabelText(), model.firstThirdFourth(), this.firstThirdFourth);
        this.write(label.getSecondThirdFourthLabelText(), model.secondThirdFourth(), this.secondThirdFourth);
        this.write(label.getIntersectionLabelText(), model.intersection(), this.intersection);
        this.write(label.getUnionLabelText(), model.union(), this.union);
        boolean fo = STDOUT.equals(this.firstOnly);
        boolean so = STDOUT.equals(this.secondOnly);
        boolean to = STDOUT.equals(this.thirdOnly);
        boolean ro = STDOUT.equals(this.fourthOnly);
        boolean fs = STDOUT.equals(this.firstSecond);
        boolean ft = STDOUT.equals(this.firstThird);
        boolean fr = STDOUT.equals(this.firstFourth);
        boolean st = STDOUT.equals(this.secondThird);
        boolean sr = STDOUT.equals(this.secondFourth);
        boolean tr = STDOUT.equals(this.thirdFourth);
        boolean fst = STDOUT.equals(this.firstSecondThird);
        boolean fsr = STDOUT.equals(this.firstSecondFourth);
        boolean ftr = STDOUT.equals(this.firstThirdFourth);
        boolean str = STDOUT.equals(this.secondThirdFourth);
        boolean i = STDOUT.equals(this.intersection);
        boolean u = STDOUT.equals(this.union);
        PrintWriter stdout = null;
        stdout = new PrintWriter(new BufferedWriter(new OutputStreamWriter(System.out)));
        if (this.header()) {
            Venn4.write(fo, label.getFirstOnlyLabelText(), stdout);
            Venn4.write(so, label.getSecondOnlyLabelText(), stdout);
            Venn4.write(to, label.getThirdOnlyLabelText(), stdout);
            Venn4.write(ro, label.getFourthOnlyLabelText(), stdout);
            Venn4.write(fs, label.getFirstSecondLabelText(), stdout);
            Venn4.write(ft, label.getFirstThirdLabelText(), stdout);
            Venn4.write(fr, label.getFirstFourthLabelText(), stdout);
            Venn4.write(st, label.getSecondThirdLabelText(), stdout);
            Venn4.write(sr, label.getSecondFourthLabelText(), stdout);
            Venn4.write(tr, label.getThirdFourthLabelText(), stdout);
            Venn4.write(fst, label.getFirstSecondThirdLabelText(), stdout);
            Venn4.write(fsr, label.getFirstSecondFourthLabelText(), stdout);
            Venn4.write(ftr, label.getFirstThirdFourthLabelText(), stdout);
            Venn4.write(str, label.getSecondThirdFourthLabelText(), stdout);
            Venn4.write(i, label.getIntersectionLabelText(), stdout);
            Venn4.write(u, label.getUnionLabelText(), stdout);
            stdout.print("\n");
        }
        if (this.count()) {
            Venn4.write(fo, model.firstOnly().size(), stdout);
            Venn4.write(so, model.secondOnly().size(), stdout);
            Venn4.write(to, model.thirdOnly().size(), stdout);
            Venn4.write(ro, model.fourthOnly().size(), stdout);
            Venn4.write(fs, model.firstSecond().size(), stdout);
            Venn4.write(ft, model.firstThird().size(), stdout);
            Venn4.write(fr, model.firstFourth().size(), stdout);
            Venn4.write(st, model.secondThird().size(), stdout);
            Venn4.write(sr, model.secondFourth().size(), stdout);
            Venn4.write(tr, model.thirdFourth().size(), stdout);
            Venn4.write(fst, model.firstSecondThird().size(), stdout);
            Venn4.write(fsr, model.firstSecondFourth().size(), stdout);
            Venn4.write(ftr, model.firstThirdFourth().size(), stdout);
            Venn4.write(str, model.secondThirdFourth().size(), stdout);
            Venn4.write(i, model.intersection().size(), stdout);
            Venn4.write(u, model.union().size(), stdout);
            stdout.print("\n");
        } else {
            boolean remaining = fo || so || to || ro || fs || ft || fr || st || sr || tr || fst || fsr || ftr || str || i || u;
            Iterator<String> foit = model.firstOnly().iterator();
            Iterator<String> soit = model.secondOnly().iterator();
            Iterator<String> toit = model.thirdOnly().iterator();
            Iterator roit = model.fourthOnly().iterator();
            Iterator<String> fsit = model.firstSecond().iterator();
            Iterator<String> ftit = model.firstThird().iterator();
            Iterator<String> frit = model.firstFourth().iterator();
            Iterator<String> stit = model.secondThird().iterator();
            Iterator<String> srit = model.secondFourth().iterator();
            Iterator<String> trit = model.thirdFourth().iterator();
            Iterator<String> fstit = model.firstSecondThird().iterator();
            Iterator<String> fsrit = model.firstSecondFourth().iterator();
            Iterator<String> ftrit = model.firstThirdFourth().iterator();
            Iterator<String> strit = model.secondThirdFourth().iterator();
            Iterator<String> iit = model.intersection().iterator();
            Iterator<String> uit = model.union().iterator();
            while (remaining) {
                Venn4.write(fo, foit, stdout);
                Venn4.write(so, soit, stdout);
                Venn4.write(to, toit, stdout);
                Venn4.write(ro, foit, stdout);
                Venn4.write(fs, fsit, stdout);
                Venn4.write(ft, ftit, stdout);
                Venn4.write(fr, frit, stdout);
                Venn4.write(st, stit, stdout);
                Venn4.write(sr, srit, stdout);
                Venn4.write(tr, trit, stdout);
                Venn4.write(fst, fstit, stdout);
                Venn4.write(fsr, fsrit, stdout);
                Venn4.write(ftr, ftrit, stdout);
                Venn4.write(str, strit, stdout);
                Venn4.write(i, iit, stdout);
                Venn4.write(u, uit, stdout);
                remaining = fo && foit.hasNext() || so && soit.hasNext() || to && toit.hasNext() || ro && roit.hasNext() || fs && fsit.hasNext() || ft && ftit.hasNext() || fr && frit.hasNext() || st && stit.hasNext() || sr && srit.hasNext() || tr && trit.hasNext() || fst && fstit.hasNext() || fsr && fsrit.hasNext() || ftr && ftrit.hasNext() || str && strit.hasNext() || i && iit.hasNext() || u && uit.hasNext();
                stdout.print("\n");
            }
        }
        try {
            stdout.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void main(String[] args) {
        CommandLine commandLine = null;
        ArgumentList arguments = null;
        try {
            Switch help = new Switch("h", "help", "display help message");
            Switch count = new Switch("c", "count", "output count(s) only");
            Switch header = new Switch("e", "header", "output header(s)");
            FileArgument firstOnly = new FileArgument("f", "first-only", "first only output file", false);
            FileArgument secondOnly = new FileArgument("s", "second-only", "second only output file", false);
            FileArgument thirdOnly = new FileArgument("t", "third-only", "third only output file", false);
            FileArgument fourthOnly = new FileArgument("r", "fourth-only", "fourth only output file", false);
            FileArgument firstSecond = new FileArgument("j", "first-second", "first second output file", false);
            FileArgument firstThird = new FileArgument("k", "first-third", "first third output file", false);
            FileArgument firstFourth = new FileArgument("l", "first-fourth", "first fourth output file", false);
            FileArgument secondThird = new FileArgument("m", "second-third", "second third output file", false);
            FileArgument secondFourth = new FileArgument("n", "second-fourth", "second fourth output file", false);
            FileArgument thirdFourth = new FileArgument("o", "third-fourth", "third fourth output file", false);
            FileArgument firstSecondThird = new FileArgument("p", "first-second-third", "first second third output file", false);
            FileArgument firstSecondFourth = new FileArgument("q", "first-second-fourth", "first second fourth output file", false);
            FileArgument firstThirdFourth = new FileArgument("v", "first-third-fourth", "first third fourth output file", false);
            FileArgument secondThirdFourth = new FileArgument("w", "second-third-fourth", "second third fourth output file", false);
            FileArgument intersection = new FileArgument("i", "intersection", "intersection output file", false);
            FileArgument union = new FileArgument("u", "union", "union output file", false);
            arguments = new ArgumentList(new Argument[]{help, count, header, firstOnly, secondOnly, thirdOnly, fourthOnly, firstSecond, firstThird, firstFourth, secondThird, secondFourth, thirdFourth, firstSecondThird, firstSecondFourth, firstThirdFourth, secondThirdFourth, intersection, union});
            commandLine = new CommandLine(args);
            CommandLineParser.parse((CommandLine)commandLine, (ArgumentList)arguments);
            if (help.wasFound()) {
                Usage.usage((String)USAGE, null, (CommandLine)commandLine, (ArgumentList)arguments, (OutputStream)System.out);
            } else {
                if (args.length < 4) {
                    throw new IllegalArgumentException("must have at least four file arguments, first, second, third and fourth input files");
                }
                File first = new File(args[args.length - 4]);
                File second = new File(args[args.length - 3]);
                File third = new File(args[args.length - 2]);
                File fourth = new File(args[args.length - 1]);
                if (first.getName().startsWith("-") || second.getName().startsWith("-") || third.getName().startsWith("-") || fourth.getName().startsWith("-")) {
                    throw new IllegalArgumentException("must have at least four file arguments, first, second, third and fourth input files");
                }
                File f = Venn4.defaultIfFound(firstOnly, first, second, third, fourth, STDOUT);
                File s = Venn4.defaultIfFound(secondOnly, first, second, third, fourth, STDOUT);
                File t = Venn4.defaultIfFound(thirdOnly, first, second, third, fourth, STDOUT);
                File r = Venn4.defaultIfFound(fourthOnly, first, second, third, fourth, STDOUT);
                File j = Venn4.defaultIfFound(firstSecond, first, second, third, fourth, STDOUT);
                File k = Venn4.defaultIfFound(firstThird, first, second, third, fourth, STDOUT);
                File l = Venn4.defaultIfFound(firstFourth, first, second, third, fourth, STDOUT);
                File m = Venn4.defaultIfFound(secondThird, first, second, third, fourth, STDOUT);
                File n = Venn4.defaultIfFound(secondFourth, first, second, third, fourth, STDOUT);
                File o = Venn4.defaultIfFound(thirdFourth, first, second, third, fourth, STDOUT);
                File p = Venn4.defaultIfFound(firstSecondThird, first, second, third, fourth, STDOUT);
                File q = Venn4.defaultIfFound(firstSecondFourth, first, second, third, fourth, STDOUT);
                File v = Venn4.defaultIfFound(firstThirdFourth, first, second, third, fourth, STDOUT);
                File w = Venn4.defaultIfFound(secondThirdFourth, first, second, third, fourth, STDOUT);
                File i = Venn4.defaultIfFound(intersection, first, second, third, fourth, STDOUT);
                File u = Venn4.defaultIfFound(union, first, second, third, fourth, STDOUT);
                new Venn4(count.wasFound(), header.wasFound(), first, second, third, fourth, f, s, t, r, j, k, l, m, n, o, p, q, v, w, i, u).run();
            }
        }
        catch (CommandLineParseException e) {
            Usage.usage((String)USAGE, (Throwable)e, commandLine, arguments, (OutputStream)System.err);
        }
        catch (IllegalArgumentException e) {
            Usage.usage((String)USAGE, (Throwable)e, commandLine, arguments, (OutputStream)System.err);
        }
    }
}

