/*
 * Decompiled with CFR 0.152.
 */
package org.dishevelled.weighted;

import java.util.AbstractCollection;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import org.dishevelled.weighted.WeightedMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class HashWeightedMap<E>
implements WeightedMap<E> {
    private final Map<E, Double> map;
    private Double totalWeight = 0.0;
    private Random random = new Random();
    private transient Map<E, Integer> rank;
    private transient boolean dirty;
    private transient EntrySet entrySet;
    private transient KeySet keySet;
    private transient Values values;
    private static final int DEFAULT_INITIAL_CAPACITY = 16;
    private static final float DEFAULT_LOAD_FACTOR = 0.75f;
    private final transient Comparator<E> byRankDescending = new Comparator<E>(){

        @Override
        public int compare(E e1, E e2) {
            Double w1 = HashWeightedMap.this.normalizedWeight(e1);
            Double w2 = HashWeightedMap.this.normalizedWeight(e2);
            return w2.compareTo(w1);
        }
    };

    public HashWeightedMap() {
        this.map = new HashMap<E, Double>();
        this.dirty = true;
    }

    public HashWeightedMap(int initialCapacity) {
        this.map = new HashMap<E, Double>(initialCapacity, 0.75f);
        this.dirty = true;
    }

    public HashWeightedMap(int initialCapacity, float loadFactor) {
        this.map = new HashMap<E, Double>(initialCapacity, loadFactor);
        this.dirty = true;
    }

    public HashWeightedMap(WeightedMap<? extends E> weightedMap) {
        this.map = new HashMap<E, Double>(Math.max(2 * weightedMap.size(), 16), 0.75f);
        this.putAll((Map<? extends E, ? extends Double>)weightedMap);
    }

    public void setRandom(Random random) {
        if (random == null) {
            throw new IllegalArgumentException("random must not be null");
        }
        this.random = random;
    }

    @Override
    public void clear() {
        this.map.clear();
        this.dirty = true;
        this.totalWeight = 0.0;
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public boolean containsKey(Object o) {
        return this.map.containsKey(o);
    }

    @Override
    public boolean containsValue(Object o) {
        return this.map.containsValue(o);
    }

    @Override
    public Double get(Object o) {
        return this.map.get(o);
    }

    @Override
    public Double put(E e, Double w) {
        if (w < 0.0) {
            throw new IllegalArgumentException("w must be >= 0.0d");
        }
        Double oldWeight = this.map.put(e, w);
        if (oldWeight != null) {
            this.totalWeight = this.totalWeight - oldWeight;
        }
        this.dirty = true;
        this.totalWeight = this.totalWeight + w;
        return oldWeight;
    }

    @Override
    public void putAll(Map<? extends E, ? extends Double> t) {
        for (Map.Entry<E, Double> e : t.entrySet()) {
            this.put(e.getKey(), e.getValue());
        }
    }

    @Override
    public Double remove(Object o) {
        Double w = this.map.remove(o);
        if (w != null) {
            this.dirty = true;
            this.totalWeight = this.totalWeight - w;
        }
        return w;
    }

    @Override
    public E sample() {
        Double r = this.random.nextDouble();
        for (E e : this.keySet()) {
            if (!((r = Double.valueOf(r - this.normalizedWeight(e))) <= 0.0)) continue;
            return e;
        }
        return null;
    }

    @Override
    public Double weight(E e) {
        return this.map.get(e);
    }

    @Override
    public Double normalizedWeight(E e) {
        if (this.isEmpty()) {
            return null;
        }
        if (this.totalWeight == 0.0) {
            return 0.0;
        }
        Double w = this.weight(e);
        if (w == null) {
            return null;
        }
        return w / this.totalWeight;
    }

    @Override
    public Double totalWeight() {
        return this.totalWeight;
    }

    @Override
    public int rank(E e) {
        if (this.dirty) {
            this.calculateRank();
            this.dirty = false;
        }
        return this.rank.containsKey(e) ? this.rank.get(e) : -1;
    }

    @Override
    public int maximumRank() {
        if (this.isEmpty()) {
            return -1;
        }
        int maximumRank = 0;
        for (E e : this.keySet()) {
            int currentRank = this.rank(e);
            if (currentRank <= maximumRank) continue;
            maximumRank = currentRank;
        }
        return maximumRank;
    }

    private void calculateRank() {
        this.rank = new HashMap<E, Integer>(this.size());
        int r = 0;
        ArrayList<E> l = new ArrayList<E>(this.keySet());
        Collections.sort(l, this.byRankDescending);
        Double lastWeight = Double.NaN;
        for (Object e : l) {
            Double w = this.normalizedWeight(e);
            if (!lastWeight.equals(w)) {
                ++r;
            }
            this.rank.put(e, r);
            lastWeight = w;
        }
        l = null;
    }

    @Override
    public Set<E> keySet() {
        if (this.keySet == null) {
            this.keySet = new KeySet();
        }
        return this.keySet;
    }

    @Override
    public Collection<Double> values() {
        if (this.values == null) {
            this.values = new Values();
        }
        return this.values;
    }

    @Override
    public Set<Map.Entry<E, Double>> entrySet() {
        if (this.entrySet == null) {
            this.entrySet = new EntrySet();
        }
        return this.entrySet;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class MapEntry
    implements Map.Entry<E, Double> {
        private Map.Entry<E, Double> e;

        public MapEntry(Map.Entry<E, Double> e) {
            this.e = e;
        }

        @Override
        public boolean equals(Object o) {
            return ((Object)this.e).equals(o);
        }

        @Override
        public int hashCode() {
            return ((Object)this.e).hashCode();
        }

        @Override
        public E getKey() {
            return this.e.getKey();
        }

        @Override
        public Double getValue() {
            return this.e.getValue();
        }

        @Override
        public Double setValue(Double w) {
            if (w < 0.0) {
                throw new IllegalArgumentException("w must be >= 0.0d");
            }
            Double oldWeight = this.e.setValue(w);
            if (oldWeight != null) {
                HashWeightedMap.this.totalWeight = HashWeightedMap.this.totalWeight - oldWeight;
            }
            HashWeightedMap.this.dirty = true;
            HashWeightedMap.this.totalWeight = HashWeightedMap.this.totalWeight + w;
            return oldWeight;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class EntrySetIterator
    implements Iterator<Map.Entry<E, Double>> {
        private Iterator<Map.Entry<E, Double>> iterator;
        private Map.Entry<E, Double> e;

        public EntrySetIterator() {
            this.iterator = HashWeightedMap.this.map.entrySet().iterator();
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public Map.Entry<E, Double> next() {
            this.e = this.iterator.next();
            return new MapEntry(this.e);
        }

        @Override
        public void remove() {
            this.iterator.remove();
            HashWeightedMap.this.dirty = true;
            HashWeightedMap.this.totalWeight = HashWeightedMap.this.totalWeight - this.e.getValue();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class EntrySet
    extends AbstractSet<Map.Entry<E, Double>> {
        private EntrySet() {
        }

        @Override
        public int size() {
            return HashWeightedMap.this.map.entrySet().size();
        }

        @Override
        public void clear() {
            HashWeightedMap.this.clear();
        }

        @Override
        public Iterator<Map.Entry<E, Double>> iterator() {
            return new EntrySetIterator();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ValuesIterator
    implements Iterator<Double> {
        private Iterator<Double> iterator;
        private Double w;

        public ValuesIterator() {
            this.iterator = HashWeightedMap.this.map.values().iterator();
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public Double next() {
            this.w = this.iterator.next();
            return this.w;
        }

        @Override
        public void remove() {
            this.iterator.remove();
            HashWeightedMap.this.dirty = true;
            HashWeightedMap.this.totalWeight = HashWeightedMap.this.totalWeight - this.w;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Values
    extends AbstractCollection<Double> {
        private Values() {
        }

        @Override
        public int size() {
            return HashWeightedMap.this.map.values().size();
        }

        @Override
        public void clear() {
            HashWeightedMap.this.clear();
        }

        @Override
        public Iterator<Double> iterator() {
            return new ValuesIterator();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class KeySetIterator
    implements Iterator<E> {
        private Iterator<E> iterator;
        private E e;

        public KeySetIterator() {
            this.iterator = HashWeightedMap.this.map.keySet().iterator();
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public E next() {
            this.e = this.iterator.next();
            return this.e;
        }

        @Override
        public void remove() {
            Double w = HashWeightedMap.this.weight(this.e);
            this.iterator.remove();
            HashWeightedMap.this.dirty = true;
            HashWeightedMap.this.totalWeight = HashWeightedMap.this.totalWeight - w;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class KeySet
    extends AbstractSet<E> {
        private KeySet() {
        }

        @Override
        public int size() {
            return HashWeightedMap.this.map.keySet().size();
        }

        @Override
        public void clear() {
            HashWeightedMap.this.clear();
        }

        @Override
        public Iterator<E> iterator() {
            return new KeySetIterator();
        }
    }
}

